/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowConsumerResolver;
import org.apache.camel.component.undertow.handlers.NotFoundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCamelHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCamelHandler.class);
    private UndertowConsumerResolver resolver = new UndertowConsumerResolver();
    private ConcurrentMap<String, UndertowConsumer> consumers = new ConcurrentHashMap<String, UndertowConsumer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        UndertowConsumer consumer = this.resolver.resolve(httpExchange, this.consumers);
        if (consumer == null) {
            LOG.debug("Unable to resolve consumer matching path {}", (Object)httpExchange.getRequestPath());
            new NotFoundHandler().handleRequest(httpExchange);
            return;
        }
        HttpString requestMethod = httpExchange.getRequestMethod();
        if (Methods.OPTIONS.equals(requestMethod) && !consumer.getEndpoint().isOptionsEnabled()) {
            String allowedMethods = consumer.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS," + consumer.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            httpExchange.setResponseCode(200);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseHeaders().put(Headers.ALLOW, allowedMethods);
            httpExchange.getResponseSender().close();
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().contains(requestMethod.toString())) {
            httpExchange.setResponseCode(405);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseSender().close();
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        Exchange camelExchange = consumer.getEndpoint().createExchange(httpExchange);
        consumer.createUoW(camelExchange);
        try {
            consumer.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            consumer.getExceptionHandler().handleException((Throwable)e);
        }
        finally {
            consumer.doneUoW(camelExchange);
        }
        Object body = this.getResponseBody(httpExchange, camelExchange, consumer);
        TypeConverter tc = consumer.getEndpoint().getCamelContext().getTypeConverter();
        if (body == null) {
            LOG.trace("No payload to send as reply for exchange: " + camelExchange);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseSender().send("No response available");
        } else {
            ByteBuffer bodyAsByteBuffer = (ByteBuffer)tc.convertTo(ByteBuffer.class, body);
            httpExchange.getResponseSender().send(bodyAsByteBuffer);
        }
        httpExchange.getResponseSender().close();
    }

    private Object getResponseBody(HttpServerExchange httpExchange, Exchange camelExchange, UndertowConsumer consumer) {
        Object result = camelExchange.hasOut() ? consumer.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getOut()) : consumer.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getIn());
        return result;
    }

    public void connectConsumer(UndertowConsumer consumer) {
        this.consumers.put(consumer.getEndpoint().getEndpointUri(), consumer);
    }
}

