/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Enumeration;
import java.util.UUID;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailUidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailUidGenerator
implements MailUidGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMailUidGenerator.class);

    @Override
    public String generateUuid(MailEndpoint mailEndpoint, Message message) {
        String answer = this.generateMessageIdHeader(message);
        if (answer == null) {
            answer = this.generateMessageHash(message);
        }
        if (answer == null || ObjectHelper.isEmpty((Object)answer)) {
            answer = Integer.toString(message.getMessageNumber());
        }
        return answer;
    }

    private String generateMessageIdHeader(Message message) {
        LOG.trace("generateMessageIdHeader for msg: {}", (Object)message);
        try {
            String[] values = message.getHeader("Message-ID");
            if (values != null && values.length > 0) {
                String uid = values[0];
                LOG.trace("Message-ID header found: {}", (Object)uid);
                return uid;
            }
        }
        catch (MessagingException e) {
            LOG.warn("Cannot read headers from mail message. This exception will be ignored.", (Throwable)e);
        }
        return null;
    }

    public String generateMessageHash(Message message) {
        LOG.trace("generateMessageHash for msg: {}", (Object)message);
        String uid = null;
        StringBuilder buffer = new StringBuilder();
        try {
            Enumeration it = message.getAllHeaders();
            while (it.hasMoreElements()) {
                Header header = (Header)it.nextElement();
                buffer.append(header.getName()).append("=").append(header.getValue()).append("\n");
            }
            if (buffer.length() > 0) {
                LOG.trace("Generating UID from the following:\n {}", (Object)buffer);
                uid = UUID.nameUUIDFromBytes(buffer.toString().getBytes()).toString();
            }
        }
        catch (MessagingException e) {
            LOG.warn("Cannot read headers from mail message. This exception will be ignored.", (Throwable)e);
        }
        return uid;
    }
}

