/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.io.IOException;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.nats.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsProducer.class);
    private Connection connection;

    public NatsProducer(NatsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        NatsConfiguration config = this.getEndpoint().getNatsConfiguration();
        String body = (String)exchange.getIn().getMandatoryBody(String.class);
        LOG.debug("Publishing to topic: {}", (Object)config.getTopic());
        this.connection.publish(config.getTopic(), body.getBytes());
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting Nats Producer");
        LOG.debug("Getting Nats Connection");
        this.connection = this.getConnection();
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Nats Producer");
        LOG.debug("Closing Nats Connection");
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.close();
        }
    }

    private Connection getConnection() throws IOException, InterruptedException {
        Properties prop = this.getEndpoint().getNatsConfiguration().createProperties();
        this.connection = Connection.connect((Properties)prop);
        return this.connection;
    }
}

