/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class EnumQueryParamConverterProvider<T extends Enum<T>>
implements ParamConverterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EnumQueryParamConverterProvider.class);

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isEnum()) {
            try {
                final Method valueMethod = rawType.getMethod("value", null);
                final Method fromValueMethod = rawType.getMethod("fromValue", String.class);
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        try {
                            return fromValueMethod.invoke(null, value);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalArgumentException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }

                    public String toString(T value) {
                        try {
                            return (String)valueMethod.invoke(value, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalArgumentException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Enumeration {} does not follow JAXB convention for conversion", (Object)rawType.getName());
            }
        }
        return null;
    }
}

