/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator<T>
implements Iterator<T> {
    private Predicate<T> predicate;
    private Iterator<T> iter;
    private T nextObject;
    private boolean nextObjectSet = false;

    public FilterIterator(Iterator<T> iter, Predicate<T> predicate) {
        this.iter = iter;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    @Override
    public T next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextObject;
    }

    private boolean setNextObject() {
        while (this.iter.hasNext()) {
            T object = this.iter.next();
            if (!this.predicate.evaluate(object)) continue;
            this.nextObject = object;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean evaluate(T var1);
    }
}

