/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.nats.Connection;
import org.nats.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private Connection connection;
    private int sid;
    private boolean subscribed;

    public NatsConsumer(NatsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting Nats Consumer");
        this.executor = this.getEndpoint().createExecutor();
        LOG.debug("Getting Nats Connection");
        this.connection = this.getConnection();
        this.executor.submit(new NatsConsumingTask(this.connection, this.getEndpoint().getNatsConfiguration()));
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Flushing Messages before stopping");
        this.connection.flush();
        try {
            this.connection.unsubscribe(Integer.valueOf(this.sid));
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error during unsubscribing", (Throwable)e);
        }
        LOG.debug("Stopping Nats Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        LOG.debug("Closing Nats Connection");
        if (this.connection.isConnected()) {
            this.connection.close();
        }
    }

    private Connection getConnection() throws IOException, InterruptedException {
        Properties prop = this.getEndpoint().getNatsConfiguration().createProperties();
        this.connection = Connection.connect((Properties)prop);
        return this.connection;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    class NatsConsumingTask
    implements Runnable {
        private final Connection connection;
        private final NatsConfiguration configuration;

        public NatsConsumingTask(Connection connection, NatsConfiguration configuration) {
            this.connection = connection;
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                NatsConsumer.this.sid = this.connection.subscribe(NatsConsumer.this.getEndpoint().getNatsConfiguration().getTopic(), this.configuration.createSubProperties(), new MsgHandler(){

                    public void execute(String msg) {
                        LOG.debug("Received Message: {}", (Object)msg);
                        Exchange exchange = NatsConsumer.this.getEndpoint().createExchange();
                        exchange.getIn().setBody((Object)msg);
                        exchange.getIn().setHeader("CamelNatsMessageTimestamp", (Object)System.currentTimeMillis());
                        exchange.getIn().setHeader("CamelNatsSubscriptionId", (Object)NatsConsumer.this.sid);
                        try {
                            NatsConsumer.this.processor.process(exchange);
                        }
                        catch (Exception e) {
                            NatsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                NatsConsumer.this.getExceptionHandler().handleException("Error during processing", e);
            }
            if (this.connection.getSubscriptionCount() > 0) {
                NatsConsumer.this.setSubscribed(true);
            }
        }
    }
}

