/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.TokenIntrospection;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="introspect")
public class TokenIntrospectionService {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenIntrospectionService.class);
    private boolean blockUnsecureRequests;
    private boolean blockUnauthorizedRequests = true;
    private MessageContext mc;
    private OAuthDataProvider dataProvider;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public TokenIntrospection getTokenIntrospection(@Encoded MultivaluedMap<String, String> params) {
        UserSubject userSubject;
        this.checkSecurityContext();
        String tokenId = (String)params.getFirst((Object)"token");
        ServerAccessToken at = this.dataProvider.getAccessToken(tokenId);
        if (at == null || OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn())) {
            return new TokenIntrospection(false);
        }
        TokenIntrospection response = new TokenIntrospection(true);
        response.setClientId(at.getClient().getClientId());
        if (!at.getScopes().isEmpty()) {
            response.setScope(OAuthUtils.convertPermissionsToScope(at.getScopes()));
        }
        if ((userSubject = at.getSubject()) != null) {
            response.setUsername(at.getSubject().getLogin());
            if (userSubject.getId() != null) {
                response.setSub(userSubject.getId());
            }
        }
        if (!StringUtils.isEmpty(at.getAudiences())) {
            response.setAud(at.getAudiences());
        }
        if (at.getIssuer() != null) {
            response.setIss(at.getIssuer());
        }
        response.setIat(at.getIssuedAt());
        if (at.getExpiresIn() > 0L) {
            response.setExp(at.getIssuedAt() + at.getExpiresIn());
        }
        response.setTokenType(at.getTokenType());
        return response;
    }

    private void checkSecurityContext() {
        SecurityContext sc = this.mc.getSecurityContext();
        if (!sc.isSecure() && this.blockUnsecureRequests) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (sc.getUserPrincipal() == null && this.blockUnauthorizedRequests) {
            LOG.warning("Authenticated Principal is not available");
            ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }

    public void setBlockUnauthorizedRequests(boolean blockUnauthorizedRequests) {
        this.blockUnauthorizedRequests = blockUnauthorizedRequests;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }
}

