/*
 * Decompiled with CFR 0.152.
 */
package org.nats;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.nats.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final String version = "0.5.2";
    private Logger LOG = LoggerFactory.getLogger(Connection.class);
    public static final int DEFAULT_PORT = 4222;
    public static final String DEFAULT_URI = "nats://localhost:" + Integer.toString(4222);
    private static final int AWAITING_CONTROL = 0;
    private static final int AWAITING_MSG_PAYLOAD = 1;
    private static final int OPEN = 0;
    private static final int CLOSE = 1;
    private static final int RECONNECT = 2;
    public static final int DEFAULT_RECONNECT_TIME_WAIT = 2000;
    public static final int DEFAULT_MAX_RECONNECT_ATTEMPTS = 3;
    public static final int DEFAULT_PING_INTERVAL = 4000;
    public static final int MAX_PENDING_SIZE = 32768;
    public static final int INIT_BUFFER_SIZE = 0x100000;
    public static final int MAX_BUFFER_SIZE = 0x1000000;
    public static final long REALLOCATION_THRESHOLD = 1000L;
    private static final String CR_LF = "\r\n";
    private static final int CR_LF_LEN = "\r\n".length();
    protected static final String EMPTY = "";
    private static final String SPC = " ";
    private static final byte[] PUB = "PUB".getBytes();
    private static final byte[] SUB = "SUB".getBytes();
    private static final byte[] UNSUB = "UNSUB".getBytes();
    private static final byte[] CONNECT = "CONNECT".getBytes();
    private static final byte[] MSG = "MSG".getBytes();
    private static final byte[] PONG = "PONG".getBytes();
    private static final byte[] PING = "PING".getBytes();
    private static final byte[] INFO = "INFO".getBytes();
    private static final byte[] ERR = "-ERR".getBytes();
    private static final byte[] OK = "+OK".getBytes();
    private static final byte[] PING_REQUEST = "PING\r\n".getBytes();
    private static final int PING_REQUEST_LEN = PING_REQUEST.length;
    private static final byte[] PONG_RESPONSE = "PONG\r\n".getBytes();
    private static final int PONG_RESPONSE_LEN = PONG_RESPONSE.length;
    private static int numConnections;
    private static volatile int ssid;
    private Server[] servers;
    private int current;
    private static ConcurrentHashMap<String, Connection> conns;
    private static Pinger pinger;
    private Connection self;
    private MsgHandler connectHandler;
    private int id;
    private MsgProcessor msgProc;
    private Thread processor;
    private Properties opts;
    private SocketChannel channel;
    private ByteBuffer sendBuffer;
    private int lastPos = 0;
    private ByteBuffer receiveBuffer;
    private byte[] cmd = new byte[0x100000];
    private int status = 0;
    private ConcurrentHashMap<Integer, Subscription> subs;
    private ConcurrentLinkedQueue<MsgHandler> pongs;
    private Timer timer;
    private long lastOverflow;
    private volatile int connStatus;

    public static Connection connect(Properties popts) throws IOException, InterruptedException {
        return Connection.connect(popts, null);
    }

    public static Connection connect(Properties popts, MsgHandler handler) throws IOException, InterruptedException {
        Connection.init(popts);
        return new Connection(popts, handler);
    }

    protected static void init(Properties popts) {
        if (!popts.containsKey("verbose")) {
            popts.put("verbose", Boolean.FALSE);
        }
        if (!popts.containsKey("pedantic")) {
            popts.put("pedantic", Boolean.FALSE);
        }
        if (!popts.containsKey("reconnect")) {
            popts.put("reconnect", Boolean.TRUE);
        }
        if (!popts.containsKey("ssl")) {
            popts.put("ssl", new Boolean(false));
        }
        if (!popts.containsKey("max_reconnect_attempts")) {
            popts.put("max_reconnect_attempts", new Integer(3));
        }
        if (!popts.containsKey("reconnect_time_wait")) {
            popts.put("reconnect_time_wait", new Integer(2000));
        }
        if (!popts.containsKey("ping_interval")) {
            popts.put("ping_interval", new Integer(4000));
        }
        if (!popts.containsKey("dont_randomize_servers")) {
            popts.put("dont_randomize_servers", Boolean.FALSE);
        }
        if (System.getenv("NATS_URI") != null) {
            popts.put("uri", System.getenv("NATS_URI"));
        } else if (!popts.containsKey("uri")) {
            popts.put("uri", DEFAULT_URI);
        }
        if (System.getenv("NATS_URIS") != null) {
            popts.put("uris", System.getenv("NATS_URIS"));
        }
        if (System.getenv("NATS_VERBOSE") != null) {
            popts.put("verbose", new Boolean(System.getenv("NATS_VERBOSE")));
        }
        if (System.getenv("NATS_PEDANTIC") != null) {
            popts.put("pedantic", new Boolean(System.getenv("NATS_PEDANTIC")));
        }
        if (System.getenv("NATS_RECONNECT") != null) {
            popts.put("reconnect", new Boolean(System.getenv("NATS_RECONNECT")));
        }
        if (System.getenv("NATS_SSL") != null) {
            popts.put("ssl", new Boolean(System.getenv("NATS_SSL")));
        }
        if (System.getenv("NATS_MAX_RECONNECT_ATTEMPTS") != null) {
            popts.put("max_reconnect_attempts", (Object)Integer.parseInt(System.getenv("NATS_MAX_RECONNECT_ATTEMPTS")));
        }
        if (System.getenv("NATS_MAX_RECONNECT_TIME_WAIT") != null) {
            popts.put("max_reconnect_time_wait", (Object)Integer.parseInt(System.getenv("NATS_MAX_RECONNECT_TIME_WAIT")));
        }
        if (System.getenv("NATS_PING_INTERVAL") != null) {
            popts.put("ping_interval", (Object)Integer.parseInt(System.getenv("NATS_PING_INTERVAL")));
        }
        if (System.getenv("NATS_DONT_RANDOMIZE_SERVERS") != null) {
            popts.put("dont_randomize_servers", (Object)Boolean.parseBoolean(System.getenv("NATS_DONT_RANDOMIZE_SERVERS")));
        }
    }

    protected Connection(Properties popts, MsgHandler handler) throws IOException, InterruptedException {
        this.id = numConnections++;
        this.self = this;
        this.msgProc = new MsgProcessor();
        this.processor = new Thread((Runnable)this.msgProc, "NATS_Processor-" + this.id);
        this.sendBuffer = ByteBuffer.allocateDirect(0x100000);
        this.receiveBuffer = ByteBuffer.allocateDirect(0x100000);
        this.subs = new ConcurrentHashMap();
        this.pongs = new ConcurrentLinkedQueue();
        this.opts = popts;
        this.configServers();
        this.timer = new Timer("NATS_Timer-" + this.id);
        this.current = 0;
        if (!this.connect()) {
            throw new IOException("Failed connecting to " + this.servers[this.current].host + ":" + this.servers[this.current].port);
        }
        if (handler != null) {
            this.connectHandler = handler;
        }
        this.processor.setDaemon(true);
        this.processor.start();
        this.sendConnectCommand();
    }

    private void configServers() {
        String[] serverStrings = null;
        if (this.opts.containsKey("uris")) {
            serverStrings = ((String)this.opts.get("uris")).split(",");
        } else if (this.opts.containsKey("servers")) {
            serverStrings = ((String)this.opts.get("servers")).split(",");
        } else if (this.opts.containsKey("uri")) {
            serverStrings = ((String)this.opts.get("uri")).split(",");
        }
        this.servers = new Server[serverStrings.length];
        Random rand = (Boolean)this.opts.get("dont_randomize_servers") == Boolean.TRUE ? null : new Random();
        for (int i = 0; i < serverStrings.length; ++i) {
            int idx = i;
            while (rand != null && this.servers[idx = rand.nextInt(this.servers.length)] != null) {
            }
            String[] uri = serverStrings[i].split(":");
            this.servers[idx] = new Server();
            if (serverStrings[i].contains("@")) {
                this.servers[idx].user = uri[1].substring(2, uri[1].length());
                this.servers[idx].pass = uri[2].split("@")[0];
                this.servers[idx].host = uri[2].split("@")[1];
                this.servers[idx].port = Integer.parseInt(uri[3]);
                continue;
            }
            this.servers[idx].user = null;
            this.servers[idx].pass = null;
            this.servers[idx].host = uri[1].substring(2, uri[1].length());
            this.servers[idx].port = Integer.parseInt(uri[2]);
        }
    }

    private boolean connect() {
        try {
            InetSocketAddress addr = new InetSocketAddress(this.servers[this.current].host, this.servers[this.current].port);
            this.channel = SocketChannel.open(addr);
            while (!this.channel.isConnected()) {
            }
            this.servers[this.current].connected = true;
            this.connStatus = 0;
            conns.put(this.toString(), this);
            if (pinger == null) {
                pinger = new Pinger();
                pinger.start();
            }
        }
        catch (Exception ie) {
            return false;
        }
        return true;
    }

    private String hexRand(int limit, Random rand) {
        return Integer.toHexString(rand.nextInt(limit));
    }

    public String createInbox() {
        Random rand = new Random();
        return "_INBOX." + this.hexRand(65536, rand) + this.hexRand(65536, rand) + this.hexRand(65536, rand) + this.hexRand(65536, rand) + this.hexRand(65536, rand) + this.hexRand(0x100000, rand);
    }

    private void sendConnectCommand() throws IOException {
        String user = null;
        String pass = null;
        StringBuffer sb = new StringBuffer("CONNECT {\"verbose\":");
        sb.append(((Boolean)this.opts.get("verbose")).toString());
        sb.append(",\"pedantic\":").append((Boolean)this.opts.get("pedantic"));
        if (this.opts.get("user") != null) {
            user = this.opts.getProperty("user");
            pass = this.opts.getProperty("pass");
        }
        if (this.servers[this.current].user != null) {
            user = this.servers[this.current].user;
            pass = this.servers[this.current].pass;
        }
        if (user != null) {
            sb.append(",\"user\":\"").append(user).append("\"");
        }
        if (pass != null) {
            sb.append(",\"pass\":\"").append(pass).append("\"");
        }
        sb.append("}").append(CR_LF);
        this.sendCommand(sb.toString());
    }

    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean flush) throws IOException {
        if (flush) {
            this.flush();
        }
        this.connStatus = 1;
        this.processor.interrupt();
        this.channel.close();
        conns.remove(this.toString());
        if (conns.size() == 0) {
            pinger.interrupt();
            pinger = null;
        }
        this.timer.cancel();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void publish(String subject, String msg) throws IOException {
        this.publish(subject, null, msg, null);
    }

    public void publish(String subject, String msg, MsgHandler handler) throws IOException {
        this.publish(subject, null, msg, handler);
    }

    public void publish(String subject, String opt_reply, String msg, MsgHandler handler) throws IOException {
        this.publish(subject, opt_reply, msg.getBytes(), handler);
    }

    public void publish(String subject, byte[] msg) throws IOException {
        this.publish(subject, null, msg, null);
    }

    public void publish(String subject, byte[] msg, MsgHandler handler) throws IOException {
        this.publish(subject, null, msg, handler);
    }

    public void publish(String subject, String opt_reply, byte[] msg, MsgHandler handler) throws IOException {
        if (subject == null) {
            return;
        }
        int offset = this.bytesCopy(this.cmd, 0, "PUB ");
        offset = this.bytesCopy(this.cmd, offset, subject);
        this.cmd[offset++] = 32;
        if (opt_reply != null) {
            offset = this.bytesCopy(this.cmd, offset, opt_reply);
            this.cmd[offset++] = 32;
        }
        int length = msg.length;
        offset = this.bytesCopy(this.cmd, offset, Integer.toString(length));
        this.cmd[offset++] = 13;
        this.cmd[offset++] = 10;
        System.arraycopy(msg, 0, this.cmd, offset, length);
        offset += length;
        this.cmd[offset++] = 13;
        this.cmd[offset++] = 10;
        this.sendCommand(this.cmd, offset, false);
        if (handler != null) {
            this.sendPing(handler);
        }
    }

    private int bytesCopy(byte[] b, int start, String data) {
        int end = start + data.length();
        int idx = 0;
        while (start < end) {
            b[start] = (byte)data.charAt(idx);
            ++start;
            ++idx;
        }
        return end;
    }

    public Integer subscribe(String subject, MsgHandler handler) throws IOException {
        return this.subscribe(subject, null, handler);
    }

    public Integer subscribe(String subject, Properties popts, MsgHandler handler) throws IOException {
        Integer sid = ssid++;
        Subscription sub = new Subscription(sid, subject, handler);
        if (popts != null) {
            sub.queue = popts.getProperty("queue") == null ? SPC : popts.getProperty("queue");
            sub.max = popts.getProperty("max") == null ? -1 : Integer.parseInt(popts.getProperty("max"));
        }
        this.subs.put(sid, sub);
        this.sendSubscription(subject, sid, sub);
        return sid;
    }

    private void sendSubscription(String subject, Integer sid, Subscription sub) throws IOException {
        this.sendCommand("SUB " + subject + SPC + sub.queue + SPC + sid.toString() + CR_LF);
        if (sub.max != -1) {
            this.unsubscribe(sid, sub.max);
        }
    }

    private void sendSubscriptions() throws IOException {
        Map.Entry<Integer, Subscription> entry2 = null;
        for (Map.Entry<Integer, Subscription> entry2 : this.subs.entrySet()) {
            this.sendSubscription(entry2.getValue().subject, entry2.getKey(), entry2.getValue());
        }
    }

    public void unsubscribe(Integer sid) throws IOException {
        this.unsubscribe(sid, 0);
    }

    public void unsubscribe(Integer sid, int opt_max) throws IOException {
        Subscription sub = this.subs.get(sid);
        if (sub == null) {
            return;
        }
        if (opt_max < 0) {
            opt_max = 0;
        }
        this.sendCommand("UNSUB " + sid.toString() + SPC + Integer.toString(opt_max) + CR_LF);
        if (sub.received >= opt_max) {
            this.subs.remove(sid);
        }
    }

    public int getSubscriptionCount() {
        return this.subs.size();
    }

    private void sendCommand(String command) throws IOException {
        this.sendCommand(command.getBytes(), command.length(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(byte[] data, int length, boolean priority) throws IOException {
        while (true) {
            try {
                ByteBuffer byteBuffer = this.sendBuffer;
                synchronized (byteBuffer) {
                    this.sendBuffer.put(data, 0, length);
                    if (this.sendBuffer.position() <= length) {
                        this.timer.schedule(new TimerTask(){

                            public void run() {
                                try {
                                    Connection.this.flushPending();
                                }
                                catch (IOException e) {
                                    Connection.this.LOG.error(e.getMessage());
                                }
                            }
                        }, 1L);
                        return;
                    }
                    if (priority || this.sendBuffer.position() > 32768) {
                        this.flushPending();
                    }
                }
            }
            catch (BufferOverflowException bofe) {
                this.flushPending();
                if (this.sendBuffer.capacity() >= 0x1000000) continue;
                if (System.currentTimeMillis() - this.lastOverflow < 1000L) {
                    this.sendBuffer = ByteBuffer.allocateDirect(this.sendBuffer.capacity() * 2);
                }
                this.lastOverflow = System.currentTimeMillis();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() throws IOException {
        ByteBuffer byteBuffer = this.sendBuffer;
        synchronized (byteBuffer) {
            block7: {
                this.lastPos = this.sendBuffer.position();
                if (this.lastPos > 0) {
                    try {
                        this.sendBuffer.flip();
                        while (this.sendBuffer.position() < this.sendBuffer.limit()) {
                            this.channel.write(this.sendBuffer);
                        }
                        this.sendBuffer.clear();
                    }
                    catch (IOException ie) {
                        if (this.connStatus != 0) break block7;
                        this.connStatus = 2;
                        this.reconnect();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPing(MsgHandler handler) throws IOException {
        ConcurrentLinkedQueue<MsgHandler> concurrentLinkedQueue = this.pongs;
        synchronized (concurrentLinkedQueue) {
            this.pongs.add(handler);
        }
        this.sendCommand(PING_REQUEST, PING_REQUEST_LEN, true);
    }

    public Integer request(String subject, MsgHandler handler) throws IOException {
        return this.request(subject, EMPTY, null, handler);
    }

    public Integer request(String subject, String msg, Properties popts, MsgHandler handler) throws IOException {
        return this.request(subject, msg, null, popts, handler);
    }

    public Integer request(String subject, byte[] msg, Properties popts, MsgHandler handler) throws IOException {
        return this.request(subject, null, msg, popts, handler);
    }

    private Integer request(String subject, String msg, byte[] bmsg, Properties popts, MsgHandler handler) throws IOException {
        if (subject == null) {
            return null;
        }
        String inbox = this.createInbox();
        Integer sub = this.subscribe(inbox, popts, handler);
        if (msg != null) {
            this.publish(subject, inbox, msg, null);
        }
        return sub;
    }

    public void flush() throws IOException {
        this.flush(new MsgHandler(){});
    }

    public void flush(MsgHandler handler) throws IOException {
        handler.caller = Thread.currentThread();
        this.sendPing(handler);
        try {
            handler.caller.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getVersion() {
        return "<nats java 0.5.2>";
    }

    public void timeout(final Integer sid, long tout, Properties prop, final MsgHandler handler) {
        Subscription sub = this.subs.get(sid);
        if (sub == null) {
            return;
        }
        boolean au = false;
        if (prop != null) {
            au = prop.get("auto_unsubscribe") == null ? false : (Boolean)prop.get("auto_unsubscribe");
            sub.expected = prop.get("expected") == null ? -1 : (Integer)prop.get("expected");
        }
        final boolean auto_unsubscribe = au;
        if (sub.task != null) {
            sub.task.cancel();
        }
        final Connection parent = this;
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    if (auto_unsubscribe) {
                        parent.unsubscribe(sid);
                    }
                }
                catch (IOException e) {
                    Connection.this.LOG.error(e.getMessage());
                }
                if (handler != null) {
                    handler.execute(sid);
                }
            }
        };
        this.timer.schedule(task, tout * 1000L);
        sub.task = task;
    }

    private synchronized void reconnect() throws IOException {
        boolean doReconnect = (Boolean)this.opts.get("reconnect");
        if (doReconnect) {
            int max_reconnect_attempts = (Integer)this.opts.get("max_reconnect_attempts");
            int reconnect_time_wait = (Integer)this.opts.get("reconnect_time_wait");
            byte[] unsent = null;
            this.lastPos = this.sendBuffer.position();
            if (this.lastPos > 0) {
                unsent = new byte[this.lastPos];
                try {
                    this.sendBuffer.get(unsent, 0, this.lastPos);
                }
                catch (BufferUnderflowException e) {
                    this.LOG.info(e.getMessage());
                }
                this.sendBuffer.clear();
                this.lastPos = 0;
            }
            conns.remove(this.toString());
            block5: while (this.current < this.servers.length) {
                while (this.servers[this.current].reconnect_attempts < max_reconnect_attempts) {
                    try {
                        this.channel.close();
                        this.connect();
                        if (this.isConnected()) {
                            this.receiveBuffer.clear();
                            this.status = 0;
                            this.sendConnectCommand();
                            this.sendSubscriptions();
                            if (unsent != null) {
                                this.sendCommand(unsent, unsent.length, false);
                            }
                            this.flushPending();
                            this.connStatus = 0;
                            this.servers[this.current].reconnect_attempts = 0;
                            break block5;
                        }
                        Thread.sleep(reconnect_time_wait);
                    }
                    catch (IOException ie) {
                        this.LOG.warn(ie.getMessage());
                    }
                    catch (InterruptedException e) {
                        this.LOG.warn(e.getMessage());
                    }
                    ++this.servers[this.current].reconnect_attempts;
                }
                ++this.current;
            }
            if (this.connStatus == 2) {
                throw new IOException("Failed connecting to all servers");
            }
        }
        this.processor = new Thread((Runnable)this.msgProc, "NATS_Processor-" + this.id);
        this.processor.setDaemon(true);
        this.processor.start();
    }

    static {
        pinger = null;
        ssid = 1;
        numConnections = 0;
        conns = new ConcurrentHashMap();
    }

    private final class MsgProcessor
    implements Runnable {
        private byte[] buf = new byte[0x100000];
        private int pos;
        private String subject;
        private String optReply;
        private int payload_length;
        private Subscription sub;
        private long lastTruncated;
        private boolean reallocate;

        public MsgProcessor() {
            for (int l = 0; l < 0x100000; ++l) {
                this.buf[l] = 0;
            }
            this.pos = 0;
            this.payload_length = -1;
            this.reallocate = false;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.processMessage();
                    }
                }
                catch (AsynchronousCloseException ace) {
                    continue;
                }
                catch (InterruptedException ie) {
                }
                catch (IOException e) {
                    if (Connection.this.connStatus != 0) break;
                    Connection.this.connStatus = 2;
                    Connection.this.timer.schedule((TimerTask)new ReconnectTask(), 1L);
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessage() throws IOException, InterruptedException {
            if (Connection.this.channel.read(Connection.this.receiveBuffer) > 0) {
                int diff = 0;
                Connection.this.receiveBuffer.flip();
                block7: while (Connection.this.receiveBuffer.position() < Connection.this.receiveBuffer.limit()) {
                    switch (Connection.this.status) {
                        case 0: {
                            this.pos = this.readNextOp(Connection.this.receiveBuffer);
                            if (this.pos != 0) break;
                            if (this.comp(this.buf, MSG, 3)) {
                                Connection.this.status = 1;
                                this.parseMsg();
                                if (Connection.this.receiveBuffer.limit() >= this.payload_length + Connection.this.receiveBuffer.position() + 2) break;
                                diff = Connection.this.receiveBuffer.limit() - Connection.this.receiveBuffer.position();
                                Connection.this.receiveBuffer.compact();
                                Connection.this.receiveBuffer.position(diff);
                                this.reallocate = this.verifyTruncation();
                                return;
                            }
                            if (this.comp(this.buf, PONG, 4)) {
                                MsgHandler handler;
                                ConcurrentLinkedQueue concurrentLinkedQueue = Connection.this.pongs;
                                synchronized (concurrentLinkedQueue) {
                                    handler = (MsgHandler)Connection.this.pongs.poll();
                                }
                                this.processEvent(handler);
                                if (handler.caller == null) continue block7;
                                handler.caller.interrupt();
                                break;
                            }
                            if (this.comp(this.buf, PING, 4)) {
                                Connection.this.sendCommand(PONG_RESPONSE, PONG_RESPONSE_LEN, true);
                                break;
                            }
                            if (this.comp(this.buf, ERR, 4)) {
                                if (Connection.this.connStatus != 0) break;
                                Connection.this.connStatus = 2;
                                Connection.this.timer.schedule((TimerTask)new ReconnectTask(), 1L);
                                break;
                            }
                            if (this.comp(this.buf, OK, 3) || !this.comp(this.buf, INFO, 4) || Connection.this.connectHandler == null) break;
                            Connection.this.connectHandler.execute(Connection.this.self);
                            break;
                        }
                        case 1: {
                            Connection.this.receiveBuffer.get(this.buf, 0, this.payload_length + 2);
                            this.on_msg();
                            this.pos = 0;
                            Connection.this.status = 0;
                        }
                    }
                }
                Connection.this.receiveBuffer.clear();
                if (this.reallocate) {
                    Connection.this.receiveBuffer = ByteBuffer.allocateDirect(Connection.this.receiveBuffer.capacity() * 2);
                    this.reallocate = false;
                }
            }
        }

        private boolean verifyTruncation() {
            boolean result = false;
            if (Connection.this.receiveBuffer.capacity() < 0x1000000 && System.currentTimeMillis() - this.lastTruncated < 1000L) {
                result = true;
            }
            this.lastTruncated = System.currentTimeMillis();
            return result;
        }

        private void on_msg() throws IOException {
            ++this.sub.received;
            if (this.sub.max != -1) {
                if (this.sub.max < this.sub.received) {
                    return;
                }
                if (this.sub.max == this.sub.received) {
                    Connection.this.subs.remove(this.sub.sid);
                }
            }
            this.processEvent(this.sub.handler);
            if (this.sub.task != null && this.sub.received >= this.sub.expected) {
                this.sub.task.cancel();
                this.sub.task = null;
            }
        }

        private String getString() {
            return new String(this.buf, 0, this.payload_length);
        }

        private byte[] getByteArray() {
            byte[] arr = new byte[this.payload_length];
            System.arraycopy(this.buf, 0, arr, 0, this.payload_length);
            return arr;
        }

        private void processEvent(MsgHandler handler) throws IOException {
            switch (handler.arity) {
                case 0: {
                    handler.execute();
                    break;
                }
                case 1: {
                    handler.execute(this.getString());
                    break;
                }
                case 2: {
                    handler.execute(this.getString(), this.optReply);
                    this.optReply = null;
                    break;
                }
                case 3: {
                    handler.execute(this.getString(), this.optReply, this.subject);
                    this.optReply = null;
                    this.subject = null;
                    break;
                }
                case -1: {
                    handler.execute((Object)this.getString());
                    break;
                }
                case 11: {
                    handler.execute(this.getByteArray());
                    break;
                }
                case 12: {
                    handler.execute(this.getByteArray(), this.optReply);
                    this.optReply = null;
                    break;
                }
                case 13: {
                    handler.execute(this.getByteArray(), this.optReply, this.subject);
                    this.optReply = null;
                    this.subject = null;
                }
            }
        }

        private int readNextOp(ByteBuffer buffer) {
            int i = this.pos;
            int limit = buffer.limit();
            while (buffer.position() < limit) {
                this.buf[i] = buffer.get();
                if (i > 0 && this.buf[i] == 10 && this.buf[i - 1] == 13) {
                    return 0;
                }
                ++i;
            }
            this.lastTruncated = System.currentTimeMillis();
            return i;
        }

        private boolean comp(byte[] src, byte[] dest, int length) {
            for (int i = 0; i < length; ++i) {
                if (src[i] == dest[i]) continue;
                return false;
            }
            return true;
        }

        private void parseMsg() {
            int index = 0;
            int rid = 0;
            int start = 0;
            while (this.buf[index++] != 13) {
                if (this.buf[index] != 32) continue;
                if (rid == 1) {
                    this.subject = new String(new String(this.buf, start, index - start));
                } else if (rid == 2) {
                    this.sub = (Subscription)Connection.this.subs.get(Integer.valueOf(new String(this.buf, start, index - start)));
                } else if (rid == 3) {
                    this.optReply = new String(new String(this.buf, start, index - start));
                }
                ++rid;
                start = ++index;
            }
            this.payload_length = Integer.parseInt(new String(this.buf, start, --index - start));
        }
    }

    private class Subscription {
        public Integer sid = null;
        public String subject = null;
        public MsgHandler handler = null;
        public String queue = "";
        public int max = -1;
        public int received = 0;
        public int expected = -1;
        public TimerTask task = null;

        public Subscription(Integer psid, String psubject, MsgHandler phandler) {
            this.sid = psid;
            this.subject = psubject;
            this.handler = phandler;
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private final Logger LOG = LoggerFactory.getLogger(ReconnectTask.class);

        private ReconnectTask() {
        }

        public void run() {
            if (Connection.this.processor.isAlive()) {
                Connection.this.processor.interrupt();
            }
            try {
                Connection.this.reconnect();
            }
            catch (IOException e) {
                this.LOG.error(e.getMessage());
            }
        }
    }

    private static class Pinger
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(Pinger.class);

        public Pinger() {
            super("pinger");
            this.setDaemon(true);
        }

        public void run() {
            MsgHandler pingHandler = new MsgHandler(){};
            int ping_interval = System.getenv("NATS_PING_INTERVAL") == null ? 4000 : Integer.parseInt(System.getenv("NATS_PING_INTERVAL"));
            try {
                block3: while (true) {
                    Thread.sleep(ping_interval);
                    Enumeration e = conns.elements();
                    while (true) {
                        if (!e.hasMoreElements()) continue block3;
                        Connection conn = (Connection)e.nextElement();
                        if (conn == null || !conn.isConnected()) continue;
                        conn.sendPing(pingHandler);
                    }
                    break;
                }
            }
            catch (IOException ie) {
                LOG.error(ie.getMessage());
            }
            catch (InterruptedException e) {
                LOG.info(e.getMessage());
            }
        }
    }

    private class Server {
        public String host;
        public int port;
        public String user;
        public String pass;
        public boolean connected = false;
        public int reconnect_attempts = 0;

        private Server() {
        }
    }
}

