/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@Priority(value=1001)
public class JwsJsonClientResponseFilter
extends AbstractJwsJsonReaderProvider
implements ClientResponseFilter {
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        List<JwsSignatureVerifier> theSigVerifiers = this.getInitializedSigVerifiers();
        JwsJsonConsumer p = new JwsJsonConsumer(IOUtils.readStringFromStream((InputStream)res.getEntityStream()));
        if (this.isStrictVerification() && p.getSignatureEntries().size() != theSigVerifiers.size() || !p.verifySignatureWith(theSigVerifiers)) {
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        res.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        JwsJsonSignatureEntry sigEntry = (JwsJsonSignatureEntry)p.getSignatureEntries().get(0);
        String ct = JoseUtils.checkContentType((String)sigEntry.getUnionHeader().getContentType(), (String)this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

