/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

@Metadata(label="eip,routing")
@XmlRootElement(name="multicast")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MulticastDefinition
extends OutputDefinition<MulticastDefinition>
implements ExecutorServiceAwareDefinition<MulticastDefinition> {
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    private Boolean strategyMethodAllowNull;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean streaming;
    @XmlAttribute
    private Boolean stopOnException;
    @XmlAttribute
    @Metadata(defaultValue="0")
    private Long timeout;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;
    @XmlAttribute
    private Boolean shareUnitOfWork;
    @XmlAttribute
    private Boolean parallelAggregate;

    @Override
    public String toString() {
        return "Multicast[" + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "multicast";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor answer = this.createChildProcessor(routeContext, true);
        if (!(answer instanceof MulticastProcessor)) {
            ArrayList<Processor> list = new ArrayList<Processor>(1);
            list.add(answer);
            answer = this.createCompositeProcessor(routeContext, list);
        }
        return answer;
    }

    public MulticastDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public MulticastDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public MulticastDefinition aggregationStrategyMethodName(String methodName) {
        this.setStrategyMethodName(methodName);
        return this;
    }

    public MulticastDefinition aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(true);
        return this;
    }

    public MulticastDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public MulticastDefinition parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public MulticastDefinition parallelAggregate() {
        this.setParallelAggregate(true);
        return this;
    }

    public MulticastDefinition streaming() {
        this.setStreaming(true);
        return this;
    }

    public MulticastDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public MulticastDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public MulticastDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public MulticastDefinition onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public MulticastDefinition onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public MulticastDefinition timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public MulticastDefinition shareUnitOfWork() {
        this.setShareUnitOfWork(true);
        return this;
    }

    @Override
    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        long timeout;
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        boolean isParallelProcessing = this.getParallelProcessing() != null && this.getParallelProcessing() != false;
        boolean isShareUnitOfWork = this.getShareUnitOfWork() != null && this.getShareUnitOfWork() != false;
        boolean isStreaming = this.getStreaming() != null && this.getStreaming() != false;
        boolean isStopOnException = this.getStopOnException() != null && this.getStopOnException() != false;
        boolean isParallelAggregate = this.getParallelAggregate() != null && this.getParallelAggregate() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "Multicast", this, isParallelProcessing);
        long l = timeout = this.getTimeout() != null ? this.getTimeout() : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        if (this.onPrepareRef != null) {
            this.onPrepare = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onPrepareRef, Processor.class);
        }
        MulticastProcessor answer = new MulticastProcessor(routeContext.getCamelContext(), list, strategy, isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout, this.onPrepare, isShareUnitOfWork, isParallelAggregate);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.strategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.getStrategyMethodName());
                if (this.getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.getStrategyMethodAllowNull());
                    adapter.setAllowNullOldExchange(this.getStrategyMethodAllowNull());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.strategyRef);
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        if (this.shareUnitOfWork != null && this.shareUnitOfWork.booleanValue()) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public MulticastDefinition setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
        return this;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public Boolean getStreaming() {
        return this.streaming;
    }

    public void setStreaming(Boolean streaming) {
        this.streaming = streaming;
    }

    public Boolean getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public Boolean getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public void setStrategyMethodAllowNull(Boolean strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public Boolean getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(Boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public Boolean getParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(Boolean parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }
}

