/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public final class GroupIterator
implements Iterator<Object>,
Closeable {
    private final CamelContext camelContext;
    private final Exchange exchange;
    private final Iterator<?> it;
    private final int group;
    private final boolean skipFirst;
    private boolean closed;

    public GroupIterator(Exchange exchange, Iterator<?> it, int group) {
        this(exchange, it, group, false);
    }

    public GroupIterator(Exchange exchange, Iterator<?> it, int group, boolean skipFirst) {
        this.exchange = exchange;
        this.camelContext = exchange.getContext();
        this.it = it;
        this.group = group;
        if (group <= 0) {
            throw new IllegalArgumentException("Group must be a positive number, was: " + group);
        }
        this.skipFirst = skipFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.it instanceof Scanner) {
                Scanner scanner = (Scanner)this.it;
                scanner.close();
                IOException ioException = scanner.ioException();
                if (ioException != null) {
                    throw ioException;
                }
            } else if (this.it instanceof Closeable) {
                IOHelper.closeWithException((Closeable)((Object)this.it));
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean answer = this.it.hasNext();
        if (!answer) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        try {
            return this.doNext();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    private Object doNext() throws IOException {
        ArrayList list = new ArrayList();
        for (int count = 0; count < this.group && this.it.hasNext(); ++count) {
            Object data = this.it.next();
            list.add(data);
        }
        return list;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

