/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JPAOAuthDataProvider
extends AbstractOAuthDataProvider {
    private static final String CLIENT_TABLE_NAME = Client.class.getSimpleName();
    private static final String BEARER_TOKEN_TABLE_NAME = BearerAccessToken.class.getSimpleName();
    private static final String REFRESH_TOKEN_TABLE_NAME = RefreshToken.class.getSimpleName();
    private EntityManager entityManager;

    @Override
    public Client getClient(String clientId) throws OAuthServiceException {
        return (Client)this.getEntityManager().find(Client.class, (Object)clientId);
    }

    @Override
    public void setClient(Client client) {
        this.getEntityManager().getTransaction().begin();
        if (client.getResourceOwnerSubject() != null) {
            UserSubject sub = (UserSubject)this.getEntityManager().find(UserSubject.class, (Object)client.getResourceOwnerSubject().getLogin());
            if (sub == null) {
                this.getEntityManager().persist((Object)client.getResourceOwnerSubject());
            } else {
                client.setResourceOwnerSubject(sub);
            }
        }
        this.getEntityManager().persist((Object)client);
        this.getEntityManager().getTransaction().commit();
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.removeEntity(c);
    }

    @Override
    public List<Client> getClients(UserSubject resourceOwner) {
        return this.getClientsQuery(resourceOwner).getResultList();
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(Client c, UserSubject sub) {
        return CastUtils.cast((List)this.getTokensQuery(c, sub).getResultList());
    }

    @Override
    public List<RefreshToken> getRefreshTokens(Client c, UserSubject sub) {
        return this.getRefreshTokensQuery(c, sub).getResultList();
    }

    @Override
    public ServerAccessToken getAccessToken(String accessToken) throws OAuthServiceException {
        return (ServerAccessToken)this.getEntityManager().find(BearerAccessToken.class, (Object)accessToken);
    }

    @Override
    protected void doRevokeAccessToken(ServerAccessToken at) {
        this.removeEntity(at);
    }

    @Override
    protected RefreshToken getRefreshToken(String refreshTokenKey) {
        return (RefreshToken)this.getEntityManager().find(RefreshToken.class, (Object)refreshTokenKey);
    }

    @Override
    protected void doRevokeRefreshToken(RefreshToken rt) {
        this.removeEntity(rt);
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        this.getEntityManager().getTransaction().begin();
        LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
        for (OAuthPermission perm : serverToken.getScopes()) {
            OAuthPermission permSaved = (OAuthPermission)this.getEntityManager().find(OAuthPermission.class, (Object)perm.getPermission());
            if (permSaved != null) {
                perms.add(permSaved);
                continue;
            }
            this.getEntityManager().persist((Object)perm);
            perms.add(perm);
        }
        serverToken.setScopes(perms);
        UserSubject sub = (UserSubject)this.getEntityManager().find(UserSubject.class, (Object)serverToken.getSubject().getLogin());
        if (sub == null) {
            this.getEntityManager().persist((Object)serverToken.getSubject());
        } else {
            sub = (UserSubject)this.getEntityManager().merge((Object)serverToken.getSubject());
            serverToken.setSubject(sub);
        }
        this.getEntityManager().persist((Object)serverToken);
        this.getEntityManager().getTransaction().commit();
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        this.persistEntity(refreshToken);
    }

    protected void persistEntity(Object entity) {
        this.entityManager.getTransaction().begin();
        this.entityManager.persist(entity);
        this.entityManager.getTransaction().commit();
    }

    protected void removeEntity(Object entity) {
        this.entityManager.getTransaction().begin();
        this.entityManager.remove(entity);
        this.entityManager.getTransaction().commit();
    }

    protected TypedQuery<Client> getClientsQuery(UserSubject resourceOwnerSubject) {
        if (resourceOwnerSubject == null) {
            return this.entityManager.createQuery("SELECT c FROM " + CLIENT_TABLE_NAME + " c", Client.class);
        }
        return this.entityManager.createQuery("SELECT c FROM " + CLIENT_TABLE_NAME + " c JOIN c.resourceOwnerSubject r WHERE r.login = '" + resourceOwnerSubject.getLogin() + "'", Client.class);
    }

    protected TypedQuery<BearerAccessToken> getTokensQuery(Client c, UserSubject resourceOwnerSubject) {
        if (c == null && resourceOwnerSubject == null) {
            return this.entityManager.createQuery("SELECT t FROM " + BEARER_TOKEN_TABLE_NAME + " t", BearerAccessToken.class);
        }
        if (c == null) {
            return this.entityManager.createQuery("SELECT t FROM " + BEARER_TOKEN_TABLE_NAME + " t JOIN t.subject s WHERE s.login = '" + resourceOwnerSubject.getLogin() + "'", BearerAccessToken.class);
        }
        if (resourceOwnerSubject == null) {
            return this.entityManager.createQuery("SELECT t FROM " + BEARER_TOKEN_TABLE_NAME + " t JOIN t.client c WHERE c.clientId = '" + c.getClientId() + "'", BearerAccessToken.class);
        }
        return this.entityManager.createQuery("SELECT t FROM " + BEARER_TOKEN_TABLE_NAME + " t JOIN t.subject s JOIN t.client c WHERE s.login = '" + resourceOwnerSubject.getLogin() + "' AND c.clientId = '" + c.getClientId() + "'", BearerAccessToken.class);
    }

    protected TypedQuery<RefreshToken> getRefreshTokensQuery(Client c, UserSubject resourceOwnerSubject) {
        if (c == null && resourceOwnerSubject == null) {
            return this.entityManager.createQuery("SELECT t FROM " + REFRESH_TOKEN_TABLE_NAME + " t", RefreshToken.class);
        }
        if (c == null) {
            return this.entityManager.createQuery("SELECT t FROM " + REFRESH_TOKEN_TABLE_NAME + " t JOIN t.subject s WHERE s.login = '" + resourceOwnerSubject.getLogin() + "'", RefreshToken.class);
        }
        if (resourceOwnerSubject == null) {
            return this.entityManager.createQuery("SELECT t FROM " + REFRESH_TOKEN_TABLE_NAME + " t JOIN t.client c WHERE c.clientId = '" + c.getClientId() + "'", RefreshToken.class);
        }
        return this.entityManager.createQuery("SELECT t FROM " + REFRESH_TOKEN_TABLE_NAME + " t JOIN t.subject s JOIN t.client c WHERE s.login = '" + resourceOwnerSubject.getLogin() + "' AND c.clientId = '" + c.getClientId() + "'", RefreshToken.class);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public void close() {
        this.entityManager.close();
    }
}

