/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntPredicate;

public class JsonReceiver
implements Receiver {
    private PipelineConfiguration pipe;
    private FastStringBuffer output;
    private FastStringBuffer textBuffer = new FastStringBuffer(128);
    private Stack<NodeName> stack = new Stack();
    private boolean atStart = true;
    private StartTagBuffer startTagBuffer;
    private boolean indenting = false;
    private boolean escaped = false;
    private Stack<Set<String>> keyChecker = new Stack();
    private static final String ERR_INPUT = "FOJS0006";

    public JsonReceiver(PipelineConfiguration pipe) {
        this.setPipelineConfiguration(pipe);
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.startTagBuffer = (StartTagBuffer)pipe.getComponent(StartTagBuffer.class.getName());
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String systemId) {
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }

    public boolean isIndenting() {
        return this.indenting;
    }

    public void open() throws XPathException {
        this.output = new FastStringBuffer(2048);
    }

    public void startDocument(int properties) throws XPathException {
        if (this.output == null) {
            this.output = new FastStringBuffer(2048);
        }
    }

    public void endDocument() throws XPathException {
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        String parent = this.stack.empty() ? null : this.stack.peek().getLocalPart();
        boolean inMap = "map".equals(parent);
        this.stack.push(elemName);
        if (!elemName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: element found in wrong namespace: " + elemName.getStructuredQName().getEQName(), ERR_INPUT);
        }
        if (!this.atStart) {
            this.output.append(',');
            if (this.indenting) {
                this.indent(this.stack.size());
            }
        }
        if (inMap) {
            String key;
            if (this.startTagBuffer == null) {
                this.startTagBuffer = (StartTagBuffer)this.pipe.getComponent(StartTagBuffer.class.getName());
            }
            if ((key = this.startTagBuffer.getAttribute("", "key")) == null) {
                throw new XPathException("xml-to-json: Child elements of <map> must have a key attribute", ERR_INPUT);
            }
            String keyEscaped = this.startTagBuffer.getAttribute("", "escaped-key");
            boolean alreadyEscaped = false;
            if (keyEscaped != null) {
                try {
                    alreadyEscaped = StringConverter.STRING_TO_BOOLEAN.convertString(keyEscaped).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException e) {
                    throw new XPathException("xml-to-json: Value of escaped-key attribute '" + Err.wrap(keyEscaped) + "' is not a valid xs:boolean", ERR_INPUT);
                }
            }
            key = (alreadyEscaped ? JsonReceiver.handleEscapedString(key) : JsonReceiver.escape(key, false, new ControlChar())).toString();
            String normalizedKey = alreadyEscaped ? JsonReceiver.unescape(key) : key;
            boolean added = this.keyChecker.peek().add(normalizedKey);
            if (!added) {
                throw new XPathException("xml-to-json: duplicate key value " + Err.wrap(key), ERR_INPUT);
            }
            this.output.append('\"');
            this.output.append(key);
            this.output.append('\"');
            this.output.append(this.indenting ? " : " : ":");
        }
        String local = elemName.getLocalPart();
        this.escaped = false;
        if (local.equals("array")) {
            if (this.indenting) {
                this.indent(this.stack.size());
                this.output.append("[ ");
            } else {
                this.output.append('[');
            }
            this.atStart = true;
        } else if (local.equals("map")) {
            if (this.indenting) {
                this.indent(this.stack.size());
                this.output.append("{ ");
            } else {
                this.output.append('{');
            }
            this.atStart = true;
            this.keyChecker.push(new HashSet());
        } else if (local.equals("null")) {
            this.checkParent(local, parent);
            this.output.append("null");
            this.atStart = false;
        } else if (local.equals("string")) {
            String escapeAtt;
            if (this.startTagBuffer == null) {
                this.startTagBuffer = (StartTagBuffer)this.pipe.getComponent(StartTagBuffer.class.getName());
            }
            if ((escapeAtt = this.startTagBuffer.getAttribute("", "escaped")) != null) {
                try {
                    this.escaped = StringConverter.STRING_TO_BOOLEAN.convertString(escapeAtt).asAtomic().effectiveBooleanValue();
                }
                catch (XPathException e) {
                    throw new XPathException("xml-to-json: value of escaped attribute (" + escapeAtt + ") is not a valid xs:boolean", ERR_INPUT);
                }
            }
            this.checkParent(local, parent);
            this.atStart = false;
        } else if (local.equals("boolean") || local.equals("number")) {
            this.checkParent(local, parent);
            this.atStart = false;
        } else {
            throw new XPathException("xml-to-json: unknown element <" + local + ">", ERR_INPUT);
        }
        this.textBuffer.setLength(0);
    }

    private void checkParent(String child, String parent) throws XPathException {
        if ("null".equals(parent) || "string".equals(parent) || "number".equals(parent) || "boolean".equals(parent)) {
            throw new XPathException("xml-to-json: A " + Err.wrap(child, 1) + " element cannot appear as a child of " + Err.wrap(parent, 1), ERR_INPUT);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (attName.hasURI("") && (attName.getLocalPart().equals("key") || attName.getLocalPart().equals("escaped-key"))) {
            boolean inMap;
            boolean bl = inMap = this.stack.size() >= 2 && ((NodeName)this.stack.get(this.stack.size() - 2)).getLocalPart().equals("map");
            if (!inMap) {
                throw new XPathException("xml-to-json: The " + attName.getLocalPart() + " attribute is allowed only on elements within a map", ERR_INPUT);
            }
        } else if (attName.hasURI("") && attName.getLocalPart().equals("escaped")) {
            boolean inString;
            boolean bl = inString = !this.stack.empty() && this.stack.peek().getLocalPart().equals("string");
            if (!inString) {
                throw new XPathException("xml-to-json: The escaped attribute is allowed only on the <string> element", ERR_INPUT);
            }
        } else if (attName.hasURI("") || attName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            throw new XPathException("xml-to-json: Disallowed attribute in input: " + attName.getDisplayName(), ERR_INPUT);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        NodeName name = this.stack.pop();
        String local = name.getLocalPart();
        if (local.equals("boolean")) {
            try {
                boolean b = StringConverter.STRING_TO_BOOLEAN.convertString(this.textBuffer).asAtomic().effectiveBooleanValue();
                this.output.append(b ? "true" : "false");
            }
            catch (XPathException e) {
                throw new XPathException("xml-to-json: Value of <boolean> element is not a valid xs:boolean", ERR_INPUT);
            }
        } else if (local.equals("number")) {
            try {
                double d = StringToDouble11.getInstance().stringToNumber(this.textBuffer);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    throw new XPathException("xml-to-json: Infinity and NaN are not allowed", ERR_INPUT);
                }
                this.output.append(new DoubleValue(d).getStringValueCS());
            }
            catch (NumberFormatException e) {
                throw new XPathException("xml-to-json: Invalid number: " + this.textBuffer);
            }
        } else if (local.equals("string")) {
            this.output.append('\"');
            String str = this.textBuffer.toString();
            if (this.escaped) {
                this.output.append(JsonReceiver.handleEscapedString(str));
            } else {
                this.output.append(JsonReceiver.escape(str, false, new ControlChar()));
            }
            this.output.append('\"');
        } else if (!Whitespace.isWhite(this.textBuffer)) {
            throw new XPathException("xml-to-json: Element " + name.getDisplayName() + " must have no text content", ERR_INPUT);
        }
        this.textBuffer.setLength(0);
        this.escaped = false;
        if (local.equals("array")) {
            this.output.append(this.indenting ? " ]" : "]");
        } else if (local.equals("map")) {
            this.keyChecker.pop();
            this.output.append(this.indenting ? " }" : "}");
        }
        this.atStart = false;
    }

    private static CharSequence handleEscapedString(String str) throws XPathException {
        JsonReceiver.unescape(str);
        FastStringBuffer out = new FastStringBuffer(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' && (i == 0 || str.charAt(i - 1) != '\\')) {
                out.append("\\\"");
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                if (c == '\b') {
                    out.append("\\b");
                    continue;
                }
                if (c == '\f') {
                    out.append("\\f");
                    continue;
                }
                if (c == '\n') {
                    out.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    out.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    out.append("\\t");
                    continue;
                }
                out.append("\\u");
                String hex = Integer.toHexString(c).toUpperCase();
                while (hex.length() < 4) {
                    hex = "0" + hex;
                }
                out.append(hex);
                continue;
            }
            if (c == '/') {
                out.append("\\/");
                continue;
            }
            out.append(c);
        }
        return out;
    }

    public static CharSequence escape(CharSequence in, boolean forXml, IntPredicate hexEscapes) throws XPathException {
        FastStringBuffer out = new FastStringBuffer(in.length());
        block10: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\"': {
                    if (forXml) {
                        out.append(c);
                        continue block10;
                    }
                    out.append("\\\"");
                    continue block10;
                }
                case '\b': {
                    out.append("\\b");
                    continue block10;
                }
                case '\f': {
                    out.append("\\f");
                    continue block10;
                }
                case '\n': {
                    out.append("\\n");
                    continue block10;
                }
                case '\r': {
                    out.append("\\r");
                    continue block10;
                }
                case '\t': {
                    out.append("\\t");
                    continue block10;
                }
                case '/': {
                    out.append("\\/");
                    continue block10;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block10;
                }
                default: {
                    if (hexEscapes.matches(c)) {
                        out.append("\\u");
                        String hex = Integer.toHexString(c).toUpperCase();
                        while (hex.length() < 4) {
                            hex = "0" + hex;
                        }
                        out.append(hex);
                        continue block10;
                    }
                    out.append(c);
                }
            }
        }
        return out;
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    public void processingInstruction(String name, CharSequence data, Location locationId, int properties) throws XPathException {
    }

    public void comment(CharSequence content, Location locationId, int properties) throws XPathException {
    }

    public void close() throws XPathException {
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    public String getSystemId() {
        return null;
    }

    public String getJsonString() {
        return this.output.toString();
    }

    private void indent(int depth) {
        this.output.append('\n');
        for (int i = 0; i < depth; ++i) {
            this.output.append("  ");
        }
    }

    private static String unescape(String literal) throws XPathException {
        if (literal.indexOf(92) < 0) {
            return literal;
        }
        FastStringBuffer buffer = new FastStringBuffer(literal.length());
        block13: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (i++ == literal.length() - 1) {
                    throw new XPathException("String '" + Err.wrap(literal) + "' ends in backslash ", "FOJS0007");
                }
                switch (literal.charAt(i)) {
                    case '\"': {
                        buffer.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        buffer.append('\\');
                        continue block13;
                    }
                    case '/': {
                        buffer.append('/');
                        continue block13;
                    }
                    case 'b': {
                        buffer.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        buffer.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        buffer.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        buffer.append('\r');
                        continue block13;
                    }
                    case 't': {
                        buffer.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            String hex = literal.substring(i + 1, i + 5);
                            int code = Integer.parseInt(hex, 16);
                            buffer.append((char)code);
                            i += 4;
                            continue block13;
                        }
                        catch (Exception e) {
                            throw new XPathException("Invalid hex escape sequence in string '" + Err.wrap(literal) + "'", "FOJS0007");
                        }
                    }
                    default: {
                        throw new XPathException("Unknown escape sequence \\" + literal.charAt(i), "FOJS0007");
                    }
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static class ControlChar
    implements IntPredicate {
        private ControlChar() {
        }

        public boolean matches(int c) {
            return c < 31 || c >= 127 && c <= 159;
        }
    }
}

