/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class DeliveryReceipt {
    public static final String DELREC_ID = "id";
    public static final String DELREC_SUB = "sub";
    public static final String DELREC_DLVRD = "dlvrd";
    public static final String DELREC_SUBMIT_DATE = "submit date";
    public static final String DELREC_DONE_DATE = "done date";
    public static final String DELREC_STAT = "stat";
    public static final String DELREC_ERR = "err";
    public static final String DELREC_TEXT = "Text";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmm");
    private String id;
    private int submitted;
    private int delivered;
    private Date submitDate;
    private Date doneDate;
    private DeliveryReceiptState finalStatus;
    private String error;
    private String text;

    public DeliveryReceipt() {
    }

    public DeliveryReceipt(String formattedDeliveryReceipt) throws InvalidDeliveryReceiptException {
        try {
            this.id = DeliveryReceipt.getDeliveryReceiptValue(DELREC_ID, formattedDeliveryReceipt);
            this.submitted = Integer.parseInt(DeliveryReceipt.getDeliveryReceiptValue(DELREC_SUB, formattedDeliveryReceipt));
            this.delivered = Integer.parseInt(DeliveryReceipt.getDeliveryReceiptValue(DELREC_DLVRD, formattedDeliveryReceipt));
            this.submitDate = DeliveryReceipt.string2Date(DeliveryReceipt.getDeliveryReceiptValue(DELREC_SUBMIT_DATE, formattedDeliveryReceipt));
            this.doneDate = DeliveryReceipt.string2Date(DeliveryReceipt.getDeliveryReceiptValue(DELREC_DONE_DATE, formattedDeliveryReceipt));
            this.finalStatus = DeliveryReceiptState.getByName(DeliveryReceipt.getDeliveryReceiptValue(DELREC_STAT, formattedDeliveryReceipt));
            this.error = DeliveryReceipt.getDeliveryReceiptValue(DELREC_ERR, formattedDeliveryReceipt);
            this.text = DeliveryReceipt.getDeliveryReceiptTextValue(formattedDeliveryReceipt);
        }
        catch (Exception e) {
            throw new InvalidDeliveryReceiptException("There is an error found when parsing delivery receipt", e);
        }
    }

    public DeliveryReceipt(String id, int submitted, int delivered, Date submitDate, Date doneDate, DeliveryReceiptState finalStatus, String error, String text) {
        this.id = id;
        this.submitted = submitted;
        this.delivered = delivered;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.finalStatus = finalStatus;
        this.error = error;
        this.text = text.length() > 20 ? text.substring(0, 20) : text;
    }

    public int getDelivered() {
        return this.delivered;
    }

    public void setDelivered(int delivered) {
        this.delivered = delivered;
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public void setDoneDate(Date doneDate) {
        this.doneDate = doneDate;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public DeliveryReceiptState getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(DeliveryReceiptState finalStatus) {
        this.finalStatus = finalStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public int getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(int submitted) {
        this.submitted = submitted;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null && text.length() > 20 ? text.substring(0, 20) : text;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("id:" + this.id).append(" ").append("sub:" + DeliveryReceipt.intToString(this.submitted, 3)).append(" ").append("dlvrd:" + DeliveryReceipt.intToString(this.delivered, 3)).append(" ").append("submit date:" + this.dateFormat.format(this.submitDate)).append(" ").append("done date:" + this.dateFormat.format(this.doneDate)).append(" ").append("stat:" + (Object)((Object)this.finalStatus)).append(" ").append("err:" + this.error).append(" ").append(DELREC_TEXT.toLowerCase() + ":" + this.text);
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + this.delivered;
        result = 31 * result + (this.doneDate == null ? 0 : this.doneDate.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.finalStatus == null ? 0 : this.finalStatus.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.submitDate == null ? 0 : this.submitDate.hashCode());
        result = 31 * result + this.submitted;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeliveryReceipt other = (DeliveryReceipt)obj;
        if (!this.hasEqualId(other)) {
            return false;
        }
        if (this.submitted != other.submitted) {
            return false;
        }
        if (this.delivered != other.delivered) {
            return false;
        }
        if (!this.hasEqualSubmitDate(other)) {
            return false;
        }
        if (!this.hasEqualDoneDate(other)) {
            return false;
        }
        if (!this.hasEqualFinalStatus(other)) {
            return false;
        }
        if (!this.hasEqualError(other)) {
            return false;
        }
        return this.hasEqualText(other);
    }

    private static String intToString(int value, int digit) {
        StringBuilder stringBuilder = new StringBuilder(digit);
        stringBuilder.append(Integer.toString(value));
        while (stringBuilder.length() < digit) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    private boolean hasEqualId(DeliveryReceipt other) {
        if (this.id == null && other.id != null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    private boolean hasEqualDoneDate(DeliveryReceipt other) {
        if (this.doneDate == null && other.doneDate != null) {
            return false;
        }
        return this.doneDate.equals(other.doneDate);
    }

    private boolean hasEqualError(DeliveryReceipt other) {
        if (this.error == null && other.error != null) {
            return false;
        }
        return this.error.equals(other.error);
    }

    private boolean hasEqualFinalStatus(DeliveryReceipt other) {
        if (this.finalStatus == null && other.finalStatus != null) {
            return false;
        }
        return this.finalStatus.equals((Object)other.finalStatus);
    }

    private boolean hasEqualSubmitDate(DeliveryReceipt other) {
        if (this.submitDate == null && other.submitDate != null) {
            return false;
        }
        return this.submitDate.equals(other.submitDate);
    }

    private boolean hasEqualText(DeliveryReceipt other) {
        if (this.text == null && other.text != null) {
            return false;
        }
        return this.text.equals(other.text);
    }

    private static String getDeliveryReceiptValue(String attrName, String source) throws IndexOutOfBoundsException {
        String tmpAttr = attrName + ":";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = source.indexOf(" ", startIndex += tmpAttr.length());
        if (endIndex > 0) {
            return source.substring(startIndex, endIndex);
        }
        return source.substring(startIndex);
    }

    private static Date string2Date(String date) {
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(DeliveryReceipt.convertTwoDigitYear(year), month - 1, day, hour, minute, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    private static String getDeliveryReceiptTextValue(String source) {
        String tmpAttr = "Text:";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            tmpAttr = DELREC_TEXT.toLowerCase() + ":";
            startIndex = source.indexOf(tmpAttr);
        }
        if (startIndex < 0) {
            return null;
        }
        return source.substring(startIndex += tmpAttr.length());
    }
}

