/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.net.URL;
import java.util.ArrayList;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.camel.parser.CamelContextResource;
import org.wildfly.extension.camel.parser.CamelResolvers;
import org.wildfly.extension.camel.parser.CamelSubsystemAdd;
import org.wildfly.extension.camel.parser.SubsystemState;

final class CamelRootResource
extends SimpleResourceDefinition {
    private static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"camel");
    private static final ResourceDescriptionResolver RESOLVER = CamelResolvers.getResolver("camel");
    private static final SubsystemState subsystemState = new SubsystemState();
    final boolean registerRuntimeOnly;

    CamelRootResource(boolean registerRuntimeOnly) {
        super(SUBSYSTEM_PATH, RESOLVER, (OperationStepHandler)new CamelSubsystemAdd(subsystemState), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new CamelContextResource(subsystemState));
        if (this.registerRuntimeOnly) {
            SimpleAttributeDefinition eldef = new SimpleAttributeDefinitionBuilder("dummy", ModelType.STRING, false).build();
            SimpleListAttributeDefinition attdef = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("endpoints", (AttributeDefinition)eldef).setStorageRuntime()).build();
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)attdef, (OperationStepHandler)new CamelRuntimeOnlyHandler());
        }
    }

    class CamelRuntimeOnlyHandler
    extends AbstractRuntimeOnlyHandler {
        CamelRuntimeOnlyHandler() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName = operation.require("operation").asString();
            if ("read-attribute".equals(operationName)) {
                this.handleReadAttributeOperation(context, operation);
            }
        }

        private void handleReadAttributeOperation(OperationContext context, ModelNode operation) {
            String name = operation.require("name").asString();
            if ("endpoints".equals(name)) {
                ArrayList<ModelNode> values = new ArrayList<ModelNode>();
                for (URL aux : subsystemState.getRuntimeState().getEndpointURLs()) {
                    values.add(new ModelNode(aux.toString()));
                }
                context.getResult().set(values);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
    }
}

