/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class ServiceNowConfiguration {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    @UriParam(label="security", secret=true)
    @Metadata(required="true")
    private String userName;
    @UriParam(label="security", secret=true)
    @Metadata(required="true")
    private String password;
    @UriParam(label="security", secret=true)
    private String oauthClientId;
    @UriParam(label="security", secret=true)
    private String oauthClientSecret;
    @UriParam(label="security", secret=true)
    private String oauthTokenUrl;
    @UriParam(label="security")
    private String apiUrl;
    @UriParam
    private String resource;
    @UriParam
    private String table;
    @UriParam
    private Boolean excludeReferenceLink = false;
    @UriParam
    private Boolean suppressAutoSysField = false;
    @UriParam(defaultValue="false", enums="false,true,all")
    private String displayValue = "false";
    @UriParam
    private Boolean inputDisplayValue = false;
    @UriParam(prefix="model.", multiValue=true, javaType="java.lang.String")
    private Map<String, Class<?>> models;
    @UriParam(label="advanced")
    private ObjectMapper mapper = MAPPER;

    public String getUserName() {
        return this.userName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public boolean hasApiUrl() {
        return this.apiUrl != null;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOauthClientId() {
        return this.oauthClientId;
    }

    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    public String getOauthTokenUrl() {
        return this.oauthTokenUrl;
    }

    public boolean hasOautTokenUrl() {
        return this.oauthTokenUrl != null;
    }

    public void setOauthTokenUrl(String oauthTokenUrl) {
        this.oauthTokenUrl = oauthTokenUrl;
    }

    public boolean hasBasicAuthentication() {
        return ObjectHelper.isNotEmpty((Object)this.userName) && ObjectHelper.isNotEmpty((Object)this.password);
    }

    public boolean hasOAuthAuthentication() {
        return ObjectHelper.isNotEmpty((Object)this.userName) && ObjectHelper.isNotEmpty((Object)this.password) && ObjectHelper.isNotEmpty((Object)this.oauthClientId) && ObjectHelper.isNotEmpty((Object)this.oauthClientSecret);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Boolean getExcludeReferenceLink() {
        return this.excludeReferenceLink;
    }

    public void setExcludeReferenceLink(Boolean excludeReferenceLink) {
        this.excludeReferenceLink = excludeReferenceLink;
    }

    public Boolean getSuppressAutoSysField() {
        return this.suppressAutoSysField;
    }

    public void setSuppressAutoSysField(Boolean suppressAutoSysField) {
        this.suppressAutoSysField = suppressAutoSysField;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public Boolean getInputDisplayValue() {
        return this.inputDisplayValue;
    }

    public void setInputDisplayValue(Boolean inputDisplayValue) {
        this.inputDisplayValue = inputDisplayValue;
    }

    public Map<String, Class<?>> getModels() {
        return this.models;
    }

    public void setModels(Map<String, Class<?>> models) {
        this.models = models;
    }

    public void addModel(String name, Class<?> type) {
        if (this.models == null) {
            this.models = new HashMap();
        }
        this.models.put(name, type);
    }

    public Class<?> getModel(String name) {
        return this.getModel(name, null);
    }

    public Class<?> getModel(String name, Class<?> defaultType) {
        Class<?> model = defaultType;
        if (this.models != null && this.models.containsKey(name)) {
            model = this.models.get(name);
        }
        return model;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public boolean hasMapper() {
        return this.mapper != null;
    }
}

