/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.servicenow.ServiceNowComponent;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowExceptionMapper;
import org.apache.camel.component.servicenow.ServiceNowProducer;
import org.apache.camel.component.servicenow.auth.AuthenticationRequestFilter;
import org.apache.camel.component.servicenow.auth.OAuthToken;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;

@UriEndpoint(scheme="servicenow", title="ServiceNow", syntax="servicenow:instanceName", producerOnly=true, label="api,cloud,management")
public class ServiceNowEndpoint
extends DefaultEndpoint {
    @UriPath(description="The ServiceNow instance name ")
    @Metadata(required="true")
    private final String instanceName;
    @UriParam
    private final ServiceNowConfiguration configuration;
    private final String apiUrl;
    private final String oauthUrl;
    private final OAuthToken token;

    public ServiceNowEndpoint(String uri, ServiceNowComponent component, ServiceNowConfiguration configuration, String instanceName) throws Exception {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.instanceName = component.getCamelContext().resolvePropertyPlaceholders(instanceName);
        this.apiUrl = configuration.hasApiUrl() ? configuration.getApiUrl() : String.format("https://%s.service-now.com/api/now", instanceName);
        this.oauthUrl = configuration.hasOautTokenUrl() ? configuration.getOauthTokenUrl() : String.format("https://%s.service-now.com/oauth_token.do", instanceName);
        this.token = configuration.hasOAuthAuthentication() ? new OAuthToken(this.oauthUrl, this.configuration) : null;
    }

    public Producer createProducer() throws Exception {
        return new ServiceNowProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported");
    }

    public boolean isSingleton() {
        return true;
    }

    public ServiceNowConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public <T> T createClient(Class<T> type) throws Exception {
        return (T)JAXRSClientFactory.create((String)this.apiUrl, type, Arrays.asList(new AuthenticationRequestFilter(this.configuration, this.token), new JacksonJsonProvider(this.configuration.getMapper()), new ServiceNowExceptionMapper(this.configuration.getMapper())));
    }
}

