/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.model;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowProducerProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowTable;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowTableProcessor
extends ServiceNowProducerProcessor<ServiceNowTable> {
    public static final ServiceNowProducerProcessor.Supplier SUPPLIER = new ServiceNowProducerProcessor.Supplier(){

        @Override
        public Processor get(ServiceNowEndpoint endpoint) throws Exception {
            return new ServiceNowTableProcessor(endpoint);
        }
    };

    public ServiceNowTableProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint, ServiceNowTable.class);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> model, String action, String tableName, String sysId) throws Exception {
        if (ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            this.retrieveRecord(exchange.getIn(), model, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"create", (Object)action, (boolean)true)) {
            this.createRecord(exchange.getIn(), model, tableName);
        } else if (ObjectHelper.equal((Object)"modify", (Object)action, (boolean)true)) {
            this.modifyRecord(exchange.getIn(), model, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"delete", (Object)action, (boolean)true)) {
            this.deleteRecord(exchange.getIn(), model, tableName, sysId);
        } else if (ObjectHelper.equal((Object)"update", (Object)action, (boolean)true)) {
            this.updateRecord(exchange.getIn(), model, tableName, sysId);
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }

    private void retrieveRecord(Message in, Class<?> model, String tableName, String sysId) throws Exception {
        if (sysId == null) {
            this.setBody(in, model, ((ServiceNowTable)this.client).retrieveRecord(tableName, (String)in.getHeader("CamelServiceNowQuery", String.class), (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class), (Boolean)in.getHeader("CamelServiceNowExcludeReferenceLink", (Object)this.config.getExcludeReferenceLink(), Boolean.class), (String)in.getHeader("CamelServiceNowFields", String.class), (Integer)in.getHeader("CamelServiceNowLimit", Integer.class), (String)in.getHeader("CamelServiceNowView", String.class)));
        } else {
            this.setBody(in, model, ((ServiceNowTable)this.client).retrieveRecordById(tableName, (String)ObjectHelper.notNull((Object)sysId, (String)"sysId"), (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class), (Boolean)in.getHeader("CamelServiceNowExcludeReferenceLink", (Object)this.config.getExcludeReferenceLink(), Boolean.class), (String)in.getHeader("CamelServiceNowFields", String.class), (String)in.getHeader("CamelServiceNowView", String.class)));
        }
    }

    private void createRecord(Message in, Class<?> model, String tableName) throws Exception {
        this.validateBody(in, model);
        this.setBody(in, model, ((ServiceNowTable)this.client).createRecord(tableName, (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class), (Boolean)in.getHeader("CamelServiceNowExcludeReferenceLink", (Object)this.config.getExcludeReferenceLink(), Boolean.class), (String)in.getHeader("CamelServiceNowFields", String.class), (Boolean)in.getHeader("CamelServiceNowInputDisplayValue", (Object)this.config.getInputDisplayValue(), Boolean.class), (Boolean)in.getHeader("CamelServiceNowSuppressAutoSysField", (Object)this.config.getSuppressAutoSysField(), Boolean.class), (String)in.getHeader("CamelServiceNowView", String.class), this.mapper.writeValueAsString(in.getBody())));
    }

    private void modifyRecord(Message in, Class<?> model, String tableName, String sysId) throws Exception {
        this.validateBody(in, model);
        this.setBody(in, model, ((ServiceNowTable)this.client).modifyRecord(tableName, (String)ObjectHelper.notNull((Object)sysId, (String)"sysId"), (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class), (Boolean)in.getHeader("CamelServiceNowExcludeReferenceLink", (Object)this.config.getExcludeReferenceLink(), Boolean.class), (String)in.getHeader("CamelServiceNowFields", String.class), (Boolean)in.getHeader("CamelServiceNowInputDisplayValue", (Object)this.config.getInputDisplayValue(), Boolean.class), (Boolean)in.getHeader("CamelServiceNowSuppressAutoSysField", (Object)this.config.getSuppressAutoSysField(), Boolean.class), (String)in.getHeader("CamelServiceNowView", String.class), this.mapper.writeValueAsString(in.getBody())));
    }

    private void deleteRecord(Message in, Class<?> model, String tableName, String sysId) throws Exception {
        this.setBody(in, model, ((ServiceNowTable)this.client).deleteRecord(tableName, (String)ObjectHelper.notNull((Object)sysId, (String)"sysId")));
    }

    private void updateRecord(Message in, Class<?> model, String tableName, String sysId) throws Exception {
        this.validateBody(in, model);
        this.setBody(in, model, ((ServiceNowTable)this.client).updateRecord(tableName, (String)ObjectHelper.notNull((Object)sysId, (String)"sysId"), (String)in.getHeader("CamelServiceNowDisplayValue", (Object)this.config.getDisplayValue(), String.class), (Boolean)in.getHeader("CamelServiceNowExcludeReferenceLink", (Object)this.config.getExcludeReferenceLink(), Boolean.class), (String)in.getHeader("CamelServiceNowFields", String.class), (Boolean)in.getHeader("CamelServiceNowInputDisplayValue", (Object)this.config.getInputDisplayValue(), Boolean.class), (Boolean)in.getHeader("CamelServiceNowSuppressAutoSysField", (Object)this.config.getSuppressAutoSysField(), Boolean.class), (String)in.getHeader("CamelServiceNowView", String.class), this.mapper.writeValueAsString(in.getBody())));
    }
}

