/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.brparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.FixedLengthParser;
import net.sf.flatpack.brparse.BuffReaderDataSet;
import net.sf.flatpack.brparse.InterfaceBuffReaderParse;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FixedWidthParserUtils;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuffReaderFixedParser
extends FixedLengthParser
implements InterfaceBuffReaderParse {
    private BufferedReader br = null;
    private int lineCount = 0;
    private Map recordLengths = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(BuffReaderFixedParser.class);

    public BuffReaderFixedParser(InputStream pzmapXMLStream, InputStream dataSourceStream) {
        super(pzmapXMLStream, dataSourceStream);
    }

    public BuffReaderFixedParser(File pzmapXML, File dataSource) {
        super(pzmapXML, dataSource);
    }

    public BuffReaderFixedParser(Reader pzmapXML, Reader dataSource) {
        super(pzmapXML, dataSource);
    }

    protected BuffReaderFixedParser(Reader dataSourceReader, String dataDefinition) {
        super(dataSourceReader, dataDefinition);
    }

    protected DataSet doParse() {
        BuffReaderDataSet ds = new BuffReaderDataSet(this.getPzMetaData(), this);
        this.lineCount = 0;
        this.recordLengths = ParserUtils.calculateRecordLengths(this.getPzMetaData());
        try {
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            this.br = new BufferedReader(this.getDataSourceReader());
            return ds;
        }
        catch (IOException ex) {
            LOGGER.error("error accessing/creating inputstream", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Row buildRow(DefaultDataSet ds) {
        String line = null;
        try {
            String mdkey;
            block8: {
                while ((line = this.br.readLine()) != null) {
                    ++this.lineCount;
                    if (line.trim().length() == 0) continue;
                    mdkey = FixedWidthParserUtils.getCMDKey(this.getPzMetaData(), line);
                    int recordLength = (Integer)this.recordLengths.get(mdkey);
                    if (line.length() > recordLength) {
                        if (this.isIgnoreExtraColumns()) {
                            line = line.substring(0, recordLength);
                            this.addError(ds, "TRUNCATED LINE TO CORRECT LENGTH", this.lineCount, 1);
                            break block8;
                        } else {
                            this.addError(ds, "LINE TOO LONG. LINE IS " + line.length() + " LONG. SHOULD BE " + recordLength, this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                            continue;
                        }
                    }
                    if (line.length() >= recordLength) break block8;
                    if (this.isHandlingShortLines()) {
                        line = line + ParserUtils.padding(recordLength - line.length(), ' ');
                        this.addError(ds, "PADDED LINE TO CORRECT RECORD LENGTH", this.lineCount, 1);
                        break block8;
                    }
                    this.addError(ds, "LINE TOO SHORT. LINE IS " + line.length() + " LONG. SHOULD BE " + recordLength, this.lineCount, 2, this.isStoreRawDataToDataError() ? line : null);
                }
                return null;
            }
            Row row = new Row();
            row.setMdkey(mdkey.equals("detail") ? null : mdkey);
            List<ColumnMetaData> cmds = ParserUtils.getColumnMetaData(mdkey, this.getPzMetaData());
            row.addColumn(FixedWidthParserUtils.splitFixedText(cmds, line, this.isPreserveLeadingWhitespace(), this.isPreserveTrailingWhitespace()));
            row.setRowNumber(this.lineCount);
            if (this.isFlagEmptyRows()) {
                row.setEmpty(ParserUtils.isListElementsEmpty(row.getCols()));
            }
            if (!this.isStoreRawDataToDataSet()) return row;
            row.setRawData(line);
            return row;
        }
        catch (IOException e) {
            throw new RuntimeException("Error Fetching Record From File...", e);
        }
    }

    public void close() throws IOException {
        if (this.br != null) {
            this.br.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Problem trying to auto close file handles...", (Throwable)ex);
        }
        finally {
            super.finalize();
        }
    }
}

