/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.MongoClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbComponent
extends UriEndpointComponent {
    public static final Set<MongoDbOperation> WRITE_OPERATIONS = new HashSet<MongoDbOperation>(Arrays.asList(MongoDbOperation.insert, MongoDbOperation.save, MongoDbOperation.update, MongoDbOperation.remove));
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbComponent.class);
    private volatile MongoClient db;

    public MongoDbComponent() {
        super(MongoDbEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.db == null) {
            this.db = (MongoClient)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)remaining, MongoClient.class);
            LOG.debug("Resolved the connection with the name {} as {}", (Object)remaining, (Object)this.db);
        }
        MongoDbEndpoint endpoint = new MongoDbEndpoint(uri, this);
        endpoint.setConnectionBean(remaining);
        endpoint.setMongoConnection(this.db);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doShutdown() throws Exception {
        if (this.db != null) {
            LOG.debug("Closing the connection {} on {}", (Object)this.db, (Object)this);
            this.db.close();
        }
        super.doShutdown();
    }

    public static CamelMongoDbException wrapInCamelMongoDbException(Throwable t) {
        if (t instanceof CamelMongoDbException) {
            return (CamelMongoDbException)t;
        }
        return new CamelMongoDbException(t);
    }
}

