/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletOperationException;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(RestletProducer.class);
    private static final Pattern PATTERN = Pattern.compile("\\(([\\w\\.]*)\\)");
    private Client client;
    private boolean throwException;

    public RestletProducer(RestletEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.client = new Client(endpoint.getProtocol());
        this.client.setContext(new Context());
        this.client.getContext().getParameters().add("socketTimeout", String.valueOf(endpoint.getSocketTimeout()));
        this.client.getContext().getParameters().add("socketConnectTimeoutMs", String.valueOf(endpoint.getSocketTimeout()));
        RestletComponent component = (RestletComponent)endpoint.getComponent();
        if (component.getMaxConnectionsPerHost() != null && component.getMaxConnectionsPerHost() > 0) {
            this.client.getContext().getParameters().add("maxConnectionsPerHost", String.valueOf(component.getMaxConnectionsPerHost()));
        }
        if (component.getMaxTotalConnections() != null && component.getMaxTotalConnections() > 0) {
            this.client.getContext().getParameters().add("maxTotalConnections", String.valueOf(component.getMaxTotalConnections()));
        }
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client.start();
    }

    public void doStop() throws Exception {
        this.client.stop();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        RestletBinding binding = endpoint.getRestletBinding();
        String resourceUri = RestletProducer.buildUri(endpoint, exchange);
        Request request = new Request(endpoint.getRestletMethod(), resourceUri);
        binding.populateRestletRequestFromExchange(request, exchange);
        LOG.debug("Sending request synchronously: {} for exchangeId: {}", (Object)request, (Object)exchange.getExchangeId());
        Response response = this.client.handle(request);
        LOG.debug("Received response synchronously: {} for exchangeId: {}", (Object)response, (Object)exchange.getExchangeId());
        if (response != null) {
            Integer respCode = response.getStatus().getCode();
            if (respCode > 207 && this.throwException) {
                exchange.setException((Throwable)((Object)this.populateRestletProducerException(exchange, response, respCode)));
            } else {
                binding.populateExchangeFromRestletResponse(exchange, response);
            }
        }
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Request request;
        RestletEndpoint endpoint = (RestletEndpoint)this.getEndpoint();
        if (endpoint.isSynchronous()) {
            try {
                this.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        LOG.trace("Processing asynchronously");
        final RestletBinding binding = endpoint.getRestletBinding();
        try {
            String resourceUri = RestletProducer.buildUri(endpoint, exchange);
            request = new Request(endpoint.getRestletMethod(), resourceUri);
            binding.populateRestletRequestFromExchange(request, exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        LOG.debug("Sending request asynchronously: {} for exchangeId: {}", (Object)request, (Object)exchange.getExchangeId());
        this.client.handle(request, new Uniform(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Request request, Response response) {
                LOG.debug("Received response asynchronously: {} for exchangeId: {}", (Object)response, (Object)exchange.getExchangeId());
                try {
                    if (response != null) {
                        Integer respCode = response.getStatus().getCode();
                        if (respCode > 207 && RestletProducer.this.throwException) {
                            exchange.setException((Throwable)((Object)RestletProducer.this.populateRestletProducerException(exchange, response, respCode)));
                        } else {
                            binding.populateExchangeFromRestletResponse(exchange, response);
                        }
                    }
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                finally {
                    callback.done(false);
                }
            }
        });
        return false;
    }

    private static String buildUri(RestletEndpoint endpoint, Exchange exchange) throws CamelExchangeException {
        String uri = (String)exchange.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null) {
            uri = endpoint.getProtocol() + "://" + endpoint.getHost() + ":" + endpoint.getPort() + endpoint.getUriPattern();
        }
        LOG.trace("Substituting '(value)' placeholders in uri: {}", (Object)uri);
        Matcher matcher = PATTERN.matcher(uri);
        while (matcher.find()) {
            String key = matcher.group(1);
            String header = (String)exchange.getIn().getHeader(key, String.class);
            if (header == null) {
                throw new CamelExchangeException("Header with key: " + key + " not found in Exchange", exchange);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Replacing: {} with header value: {}", (Object)matcher.group(0), (Object)header);
            }
            uri = matcher.replaceFirst(header);
            matcher.reset(uri);
        }
        String query = (String)exchange.getIn().removeHeader("CamelRestHttpQuery");
        if (query == null) {
            query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (query != null) {
            LOG.trace("Adding query: {} to uri: {}", (Object)query, (Object)uri);
            uri = RestletProducer.addQueryToUri(uri, query);
        }
        LOG.trace("Using uri: {}", (Object)uri);
        return uri;
    }

    protected static String addQueryToUri(String uri, String query) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        StringBuilder answer = new StringBuilder();
        int index = uri.indexOf(63);
        if (index < 0) {
            answer.append(uri);
            answer.append("?");
            answer.append(query);
        } else {
            answer.append(uri.substring(0, index));
            answer.append("?");
            answer.append(query);
            String remaining = uri.substring(index + 1);
            if (remaining.length() > 0) {
                answer.append("&");
                answer.append(remaining);
            }
        }
        return answer.toString();
    }

    protected RestletOperationException populateRestletProducerException(Exchange exchange, Response response, int responseCode) {
        RestletOperationException exception;
        String copy;
        String uri = response.getRequest().getResourceRef().toString();
        String statusText = response.getStatus().getDescription();
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        if (response.getEntity() != null) {
            try {
                copy = response.getEntity().getText();
            }
            catch (Exception ex) {
                copy = ex.toString();
            }
        } else {
            copy = response.toString();
        }
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getStatus().isRedirection()) {
                String redirectLocation = response.getLocationRef().getHostIdentifier();
                exception = new RestletOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new RestletOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                LOG.trace("Parse external header {}={}", (Object)key, value);
                answer.put(key, value.toString());
            }
        }
        return answer;
    }
}

