/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Parser;
import io.nats.client.Subscription;
import io.nats.client.SubscriptionImpl;
import java.util.Arrays;

public class Message {
    private byte[] subjectBytes;
    private String subjectString;
    private byte[] replyToBytes;
    private String replyToString;
    private byte[] data;
    protected SubscriptionImpl sub;

    public Message() {
    }

    public Message(String subject, String reply, byte[] data) {
        this(data, null != data ? data.length : 0, subject, reply, null);
    }

    protected Message(Parser.MsgArg ma, SubscriptionImpl sub, byte[] buf, int offset, int length) {
        this.setSubject(ma.subject.array(), ma.subject.limit());
        if (ma.reply.limit() > 0) {
            this.setReplyTo(ma.reply.array(), ma.reply.limit());
        }
        this.sub = sub;
        if (ma.size > 0) {
            this.data = new byte[ma.size];
            try {
                System.arraycopy(buf, offset, this.data, 0, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.printf("buf.length=%d, offset=%d, data.length=%d, length=%d\n, buf=[%s]", buf.length, offset, this.data.length, length, new String(buf, offset, length));
                e.printStackTrace();
            }
        }
    }

    protected Message(byte[] data, int length, String subject, String reply, SubscriptionImpl sub) {
        this.setSubject(subject);
        this.setData(data);
        this.setReplyTo(reply);
        this.sub = sub;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getSubject() {
        if (this.subjectString == null) {
            this.subjectString = new String(this.subjectBytes, 0, this.subjectBytes.length);
        }
        return this.subjectString;
    }

    byte[] getSubjectBytes() {
        return this.subjectBytes;
    }

    public void setSubject(String subject) {
        String s = subject.trim();
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, empty, or whitespace.");
        }
        this.subjectString = subject;
        this.subjectBytes = subject.getBytes();
    }

    void setSubject(byte[] subject, int length) {
        this.subjectBytes = Arrays.copyOf(subject, length);
    }

    public String getReplyTo() {
        if (this.replyToString == null && this.replyToBytes != null) {
            this.replyToString = new String(this.replyToBytes, 0, this.replyToBytes.length);
        }
        return this.replyToString;
    }

    byte[] getReplyToBytes() {
        return this.replyToBytes;
    }

    public void setReplyTo(String replyTo) {
        if (replyTo == null) {
            this.replyToBytes = null;
        } else {
            String r = replyTo.trim();
            if (r.isEmpty()) {
                throw new IllegalArgumentException("Reply subject cannot be empty or whitespace.");
            }
            this.replyToString = replyTo;
            this.replyToBytes = replyTo.getBytes();
        }
    }

    void setReplyTo(byte[] replyTo, int length) {
        this.replyToBytes = (byte[])(replyTo == null ? null : Arrays.copyOf(replyTo, length));
    }

    public Subscription getSubscription() {
        return this.sub;
    }

    public void setData(byte[] data, int offset, int length) {
        if (data == null) {
            this.data = null;
        } else {
            this.data = new byte[length];
            System.arraycopy(data, offset, this.data, 0, length);
        }
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.setData(data, 0, data.length);
        } else {
            this.setData(null, 0, 0);
        }
    }

    public String toString() {
        int maxBytes = 32;
        int len = 0;
        byte[] b = this.getData();
        if (b != null) {
            len = b.length;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{Subject=%s;Reply=%s;Payload=<", this.getSubject(), this.getReplyTo()));
        for (int i = 0; i < maxBytes && i < len; ++i) {
            sb.append((char)b[i]);
        }
        int remainder = len - maxBytes;
        if (remainder > 0) {
            sb.append(String.format("%d more bytes", remainder));
        }
        sb.append(">}");
        return sb.toString();
    }
}

