/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.processor.remote;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.dns.DnsConfiguration;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.TextParseException;

public class DnsServiceLookupFactory
implements Function<String, Lookup> {
    private final DnsConfiguration configuration;
    private final Map<String, Lookup> cache;

    public DnsServiceLookupFactory(DnsConfiguration configuration) {
        this.configuration = configuration;
        this.cache = new ConcurrentHashMap<String, Lookup>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lookup apply(String name) {
        Lookup lookup = this.cache.get(name);
        if (lookup == null) {
            Map<String, Lookup> map = this.cache;
            synchronized (map) {
                lookup = this.cache.computeIfAbsent(name, this::createLookup);
            }
        }
        return lookup;
    }

    private Lookup createLookup(String name) {
        try {
            return new Lookup(String.format("%s.%s.%s", name, this.configuration.getProto(), this.configuration.getDomain()), 33);
        }
        catch (TextParseException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

