/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.lang.ref.WeakReference;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowProducerProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowAggregateProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowImportSetProcessor;
import org.apache.camel.component.servicenow.model.ServiceNowTableProcessor;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowProducer
extends DefaultProducer {
    private final ServiceNowEndpoint endpoint;
    private final ServiceNowConfiguration configuration;
    private final WeakThreadLocal tableCache;
    private final WeakThreadLocal aggregateCache;
    private final WeakThreadLocal importSetCache;

    public ServiceNowProducer(ServiceNowEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.tableCache = new WeakThreadLocal(ServiceNowTableProcessor.SUPPLIER);
        this.aggregateCache = new WeakThreadLocal(ServiceNowAggregateProcessor.SUPPLIER);
        this.importSetCache = new WeakThreadLocal(ServiceNowImportSetProcessor.SUPPLIER);
    }

    public void process(Exchange exchange) throws Exception {
        String resource = (String)exchange.getIn().getHeader("CamelServiceNowResource", (Object)this.configuration.getResource(), String.class);
        if (ObjectHelper.equal((Object)"table", (Object)resource, (boolean)true)) {
            this.tableCache.get().process(exchange);
        } else if (ObjectHelper.equal((Object)"aggregate", (Object)resource, (boolean)true)) {
            this.aggregateCache.get().process(exchange);
        } else if (ObjectHelper.equal((Object)"import", (Object)resource, (boolean)true)) {
            this.importSetCache.get().process(exchange);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + resource);
        }
    }

    private final class WeakThreadLocal {
        private final ThreadLocal<WeakReference<Processor>> cache = new ThreadLocal();
        private final ServiceNowProducerProcessor.Supplier supplier;

        WeakThreadLocal(ServiceNowProducerProcessor.Supplier supplier) {
            this.supplier = supplier;
        }

        public Processor get() throws Exception {
            Processor processor = null;
            WeakReference<Processor> ref = this.cache.get();
            if (ref != null) {
                processor = (Processor)ref.get();
            }
            if (processor == null) {
                processor = this.supplier.get(ServiceNowProducer.this.endpoint);
                this.cache.set(new WeakReference<Processor>(processor));
            }
            return processor;
        }
    }
}

