/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation,xml", title="JacksonXML")
@XmlRootElement(name="jacksonxml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JacksonXMLDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String xmlMapper;
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    private Boolean allowJmsType;
    @XmlAttribute
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    private Boolean useList;
    @XmlAttribute
    private Boolean enableJaxbAnnotationModule;
    @XmlAttribute
    private String moduleClassNames;
    @XmlAttribute
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;

    public JacksonXMLDataFormat() {
        super("jacksonxml");
    }

    public String getXmlMapper() {
        return this.xmlMapper;
    }

    public void setXmlMapper(String xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public Boolean getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(Boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Boolean getUseList() {
        return this.useList;
    }

    public void setUseList(Boolean useList) {
        this.useList = useList;
    }

    public Boolean getEnableJaxbAnnotationModule() {
        return this.enableJaxbAnnotationModule;
    }

    public void setEnableJaxbAnnotationModule(Boolean enableJaxbAnnotationModule) {
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    @Override
    public String getDataFormatName() {
        return "jacksonxml";
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.collectionType == null && this.collectionTypeName != null) {
            try {
                this.collectionType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.collectionTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.xmlMapper != null) {
            String ref = this.xmlMapper.startsWith("#") ? this.xmlMapper : "#" + this.xmlMapper;
            this.setProperty(camelContext, dataFormat, "xmlMapper", ref);
        }
        if (this.unmarshalType != null) {
            this.setProperty(camelContext, dataFormat, "unmarshalType", this.unmarshalType);
        }
        if (this.prettyPrint != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", this.prettyPrint);
        }
        if (this.jsonView != null) {
            this.setProperty(camelContext, dataFormat, "jsonView", this.jsonView);
        }
        if (this.include != null) {
            this.setProperty(camelContext, dataFormat, "include", this.include);
        }
        if (this.allowJmsType != null) {
            this.setProperty(camelContext, dataFormat, "allowJmsType", this.allowJmsType);
        }
        if (this.collectionType != null) {
            this.setProperty(camelContext, dataFormat, "collectionType", this.collectionType);
        }
        if (this.useList != null) {
            this.setProperty(camelContext, dataFormat, "useList", this.useList);
        }
        if (this.enableJaxbAnnotationModule != null) {
            this.setProperty(camelContext, dataFormat, "enableJaxbAnnotationModule", this.enableJaxbAnnotationModule);
        }
        if (this.moduleClassNames != null) {
            this.setProperty(camelContext, dataFormat, "modulesClassNames", this.moduleClassNames);
        }
        if (this.moduleRefs != null) {
            this.setProperty(camelContext, dataFormat, "moduleRefs", this.moduleRefs);
        }
        if (this.enableFeatures != null) {
            this.setProperty(camelContext, dataFormat, "enableFeatures", this.enableFeatures);
        }
        if (this.disableFeatures != null) {
            this.setProperty(camelContext, dataFormat, "disableFeatures", this.disableFeatures);
        }
    }
}

