/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.ApiMethodArg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiMethodParser<T> {
    public static final Pattern ARGS_PATTERN = Pattern.compile("\\s*([^<\\s]+)\\s*(<[^>]+>)?\\s+([^\\s,]+)\\s*,?");
    private static final String METHOD_PREFIX = "^(\\s*(public|final|synchronized|native)\\s+)*(\\s*<[^>]>)?\\s*(\\S+)\\s+([^\\(]+\\s*)\\(";
    private static final Pattern METHOD_PATTERN = Pattern.compile("\\s*([^<\\s]+)\\s*(<[^>]+>)?\\s+(\\S+)\\s*\\(\\s*([\\S\\s,]*)\\)\\s*;?\\s*");
    private static final String JAVA_LANG = "java.lang.";
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<T> proxyType;
    private List<String> signatures;
    private ClassLoader classLoader = ApiMethodParser.class.getClassLoader();

    public ApiMethodParser(Class<T> proxyType) {
        this.proxyType = proxyType;
    }

    public Class<T> getProxyType() {
        return this.proxyType;
    }

    public final List<String> getSignatures() {
        return this.signatures;
    }

    public final void setSignatures(List<String> signatures) {
        this.signatures = new ArrayList<String>();
        this.signatures.addAll(signatures);
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final List<ApiMethodModel> parse() {
        String name;
        List<ApiMethodModel> result = new ArrayList<ApiMethodModel>();
        for (String string : this.signatures) {
            Method method;
            if (string.startsWith("##") || ObjectHelper.isEmpty(string)) continue;
            String string4 = string.replaceAll(METHOD_PREFIX, "$4 $5(");
            string4 = string4.replaceAll("(\\(|,\\s*)final\\s+", "$1");
            string4 = string4.replaceAll("\\s*<\\s*", "<").replaceAll("\\s*>", ">");
            this.log.debug("Processing " + string4);
            Matcher methodMatcher = METHOD_PATTERN.matcher(string4);
            if (!methodMatcher.matches()) {
                throw new IllegalArgumentException("Invalid method signature " + string4);
            }
            Class<?> resultType = this.forName(methodMatcher.group(1));
            name = methodMatcher.group(3);
            String argSignature = methodMatcher.group(4);
            ArrayList<ApiMethodArg> arguments = new ArrayList<ApiMethodArg>();
            ArrayList argTypes = new ArrayList();
            Matcher argsMatcher = ARGS_PATTERN.matcher(argSignature);
            while (argsMatcher.find()) {
                Class<?> type = this.forName(argsMatcher.group(1));
                argTypes.add(type);
                String typeArgsGroup = argsMatcher.group(2);
                String typeArgs = typeArgsGroup != null ? typeArgsGroup.substring(1, typeArgsGroup.length() - 1).replaceAll(" ", "") : null;
                arguments.add(new ApiMethodArg(argsMatcher.group(3), type, typeArgs));
            }
            try {
                method = this.proxyType.getMethod(name, argTypes.toArray(new Class[argTypes.size()]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Method not found [" + string4 + "] in type " + this.proxyType.getName());
            }
            result.add(new ApiMethodModel(name, resultType, arguments, method));
        }
        result = this.processResults(result);
        HashMap allArguments = new HashMap();
        for (ApiMethodModel model : result) {
            for (ApiMethodArg argument : model.getArguments()) {
                String name2 = argument.getName();
                Class argClass = (Class)allArguments.get(name2);
                Class<?> type = argument.getType();
                if (argClass == null) {
                    allArguments.put(name2, type);
                    continue;
                }
                if (argClass == type) continue;
                throw new IllegalArgumentException("Argument [" + name2 + "] is used in multiple methods with different types " + argClass.getCanonicalName() + ", " + type.getCanonicalName());
            }
        }
        allArguments.clear();
        Collections.sort(result, new Comparator<ApiMethodModel>(){

            @Override
            public int compare(ApiMethodModel model1, ApiMethodModel model2) {
                int nameCompare = model1.name.compareTo(model2.name);
                if (nameCompare != 0) {
                    return nameCompare;
                }
                int nArgs1 = model1.arguments.size();
                int nArgsCompare = nArgs1 - model2.arguments.size();
                if (nArgsCompare != 0) {
                    return nArgsCompare;
                }
                for (int i = 0; i < nArgs1; ++i) {
                    int argCompare = ((ApiMethodArg)model1.arguments.get(i)).getName().compareTo(((ApiMethodArg)model2.arguments.get(i)).getName());
                    if (argCompare == 0) continue;
                    return argCompare;
                }
                ApiMethodParser.this.log.warn("Duplicate methods found [" + model1 + "], [" + model2 + "]");
                return 0;
            }
        });
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (ApiMethodModel model : result) {
            name = model.getName();
            char[] upperCase = new char[name.length()];
            char[] lowerCase = name.toCharArray();
            for (int i = 0; i < upperCase.length; ++i) {
                upperCase[i] = Character.toUpperCase(lowerCase[i]);
            }
            String uniqueName = new String(upperCase);
            Integer suffix = (Integer)hashMap.get(uniqueName);
            if (suffix == null) {
                hashMap.put(uniqueName, 1);
            } else {
                hashMap.put(uniqueName, suffix + 1);
                StringBuilder builder = new StringBuilder(uniqueName);
                builder.append("_").append(suffix);
                uniqueName = builder.toString();
            }
            model.uniqueName = uniqueName;
        }
        return result;
    }

    protected List<ApiMethodModel> processResults(List<ApiMethodModel> result) {
        return result;
    }

    protected Class<?> forName(String className) {
        try {
            return ApiMethodParser.forName(className, this.classLoader);
        }
        catch (ClassNotFoundException e1) {
            throw new IllegalArgumentException("Error loading class " + className);
        }
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> result;
        block12: {
            result = null;
            try {
                result = PRIMITIVE_TYPES.get(className);
                if (result == null) {
                    result = Class.forName(className, true, classLoader);
                }
            }
            catch (ClassNotFoundException e) {
                if (className.endsWith("[]")) {
                    int firstDim = className.indexOf(91);
                    int nDimensions = (className.length() - firstDim) / 2;
                    result = Array.newInstance(ApiMethodParser.forName(className.substring(0, firstDim), classLoader), new int[nDimensions]).getClass();
                } else if (className.indexOf(46) != -1) {
                    String innerClass = className;
                    while (result == null && innerClass.indexOf(46) != -1) {
                        int endIndex = innerClass.lastIndexOf(46);
                        innerClass = innerClass.substring(0, endIndex) + "$" + innerClass.substring(endIndex + 1);
                        try {
                            result = Class.forName(innerClass, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
                if (result != null || className.startsWith(JAVA_LANG)) break block12;
                try {
                    result = ApiMethodParser.forName(JAVA_LANG + className, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }

    static {
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
    }

    public static final class ApiMethodModel {
        private final String name;
        private final Class<?> resultType;
        private final List<ApiMethodArg> arguments;
        private final Method method;
        private String uniqueName;

        protected ApiMethodModel(String name, Class<?> resultType, List<ApiMethodArg> arguments, Method method) {
            this.name = name;
            this.resultType = resultType;
            this.arguments = arguments;
            this.method = method;
        }

        protected ApiMethodModel(String uniqueName, String name, Class<?> resultType, List<ApiMethodArg> arguments, Method method) {
            this.name = name;
            this.uniqueName = uniqueName;
            this.resultType = resultType;
            this.arguments = arguments;
            this.method = method;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getResultType() {
            return this.resultType;
        }

        public Method getMethod() {
            return this.method;
        }

        public List<ApiMethodArg> getArguments() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.resultType.getName()).append(" ");
            builder.append(this.name).append("(");
            for (ApiMethodArg argument : this.arguments) {
                builder.append(argument.getType().getCanonicalName()).append(" ");
                builder.append(argument.getName()).append(", ");
            }
            if (!this.arguments.isEmpty()) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append(");");
            return builder.toString();
        }
    }
}

