/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixRequestEvents;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class SerialHystrixRequestEvents
extends SerialHystrixMetric {
    public static byte[] toBytes(HystrixRequestEvents requestEvents) {
        byte[] retVal = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            CBORGenerator cbor = cborFactory.createGenerator((OutputStream)bos);
            SerialHystrixRequestEvents.serializeRequestEvents(requestEvents, (JsonGenerator)cbor);
            retVal = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    public static String toJsonString(HystrixRequestEvents requestEvents) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixRequestEvents.serializeRequestEvents(requestEvents, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    private static void serializeRequestEvents(HystrixRequestEvents requestEvents, JsonGenerator json) {
        try {
            json.writeStartArray();
            for (Map.Entry entry : requestEvents.getExecutionsMappedToLatencies().entrySet()) {
                SerialHystrixRequestEvents.convertExecutionToJson(json, (HystrixRequestEvents.ExecutionSignature)entry.getKey(), (List)entry.getValue());
            }
            json.writeEndArray();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void convertExecutionToJson(JsonGenerator json, HystrixRequestEvents.ExecutionSignature executionSignature, List<Integer> latencies) throws IOException {
        json.writeStartObject();
        json.writeStringField("name", executionSignature.getCommandName());
        json.writeArrayFieldStart("events");
        ExecutionResult.EventCounts eventCounts = executionSignature.getEventCounts();
        for (HystrixEventType eventType : HystrixEventType.values()) {
            if (eventType.equals((Object)HystrixEventType.COLLAPSED) || !eventCounts.contains(eventType)) continue;
            int eventCount = eventCounts.getCount(eventType);
            if (eventCount > 1) {
                json.writeStartObject();
                json.writeStringField("name", eventType.name());
                json.writeNumberField("count", eventCount);
                json.writeEndObject();
                continue;
            }
            json.writeString(eventType.name());
        }
        json.writeEndArray();
        json.writeArrayFieldStart("latencies");
        for (int latency : latencies) {
            json.writeNumber(latency);
        }
        json.writeEndArray();
        if (executionSignature.getCachedCount() > 0) {
            json.writeNumberField("cached", executionSignature.getCachedCount());
        }
        if (executionSignature.getEventCounts().contains(HystrixEventType.COLLAPSED)) {
            json.writeObjectFieldStart("collapsed");
            json.writeStringField("name", executionSignature.getCollapserKey().name());
            json.writeNumberField("count", executionSignature.getCollapserBatchSize());
            json.writeEndObject();
        }
        json.writeEndObject();
    }
}

