/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalExtendedStats
extends InternalStats
implements ExtendedStats {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("extended_stats", "estats");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalExtendedStats readResult(StreamInput in) throws IOException {
            InternalExtendedStats result = new InternalExtendedStats();
            result.readFrom(in);
            return result;
        }
    };
    private double sumOfSqrs;
    private double sigma;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalExtendedStats() {
    }

    public InternalExtendedStats(String name, long count, double sum, double min, double max, double sumOfSqrs, double sigma, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, count, sum, min, max, formatter, pipelineAggregators, metaData);
        this.sumOfSqrs = sumOfSqrs;
        this.sigma = sigma;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public double value(String name) {
        if ("sum_of_squares".equals(name)) {
            return this.sumOfSqrs;
        }
        if ("variance".equals(name)) {
            return this.getVariance();
        }
        if ("std_deviation".equals(name)) {
            return this.getStdDeviation();
        }
        if ("std_upper".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER);
        }
        if ("std_lower".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER);
        }
        return super.value(name);
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSqrs;
    }

    @Override
    public double getVariance() {
        return (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)this.count;
    }

    @Override
    public double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        if (bound.equals((Object)ExtendedStats.Bounds.UPPER)) {
            return this.getAvg() + this.getStdDeviation() * this.sigma;
        }
        return this.getAvg() - this.getStdDeviation() * this.sigma;
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString(Metrics.sum_of_squares.name());
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString(Metrics.variance.name());
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString(Metrics.std_deviation.name());
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        return bound == ExtendedStats.Bounds.UPPER ? this.valueAsString(Metrics.std_upper.name()) : this.valueAsString(Metrics.std_lower.name());
    }

    @Override
    public InternalExtendedStats doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double sumOfSqrs = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            InternalExtendedStats stats = (InternalExtendedStats)aggregation;
            if (stats.sigma != this.sigma) {
                throw new IllegalStateException("Cannot reduce other stats aggregations that have a different sigma");
            }
            sumOfSqrs += stats.getSumOfSquares();
        }
        InternalAggregation stats = super.doReduce((List)aggregations, reduceContext);
        return new InternalExtendedStats(this.name, ((InternalStats)stats).getCount(), ((InternalStats)stats).getSum(), ((InternalStats)stats).getMin(), ((InternalStats)stats).getMax(), sumOfSqrs, this.sigma, this.valueFormatter, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public void readOtherStatsFrom(StreamInput in) throws IOException {
        this.sumOfSqrs = in.readDouble();
        this.sigma = in.getVersion().onOrAfter(Version.V_1_4_3) ? in.readDouble() : 2.0;
    }

    @Override
    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sumOfSqrs);
        if (out.getVersion().onOrAfter(Version.V_1_4_3)) {
            out.writeDouble(this.sigma);
        }
    }

    @Override
    protected XContentBuilder otherStatsToXCotent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.SUM_OF_SQRS, this.count != 0L ? Double.valueOf(this.sumOfSqrs) : null);
        builder.field(Fields.VARIANCE, this.count != 0L ? Double.valueOf(this.getVariance()) : null);
        builder.field(Fields.STD_DEVIATION, this.count != 0L ? Double.valueOf(this.getStdDeviation()) : null);
        builder.startObject(Fields.STD_DEVIATION_BOUNDS).field(Fields.UPPER, this.count != 0L ? Double.valueOf(this.getStdDeviationBound(ExtendedStats.Bounds.UPPER)) : null).field(Fields.LOWER, this.count != 0L ? Double.valueOf(this.getStdDeviationBound(ExtendedStats.Bounds.LOWER)) : null).endObject();
        if (this.count != 0L && !(this.valueFormatter instanceof ValueFormatter.Raw)) {
            builder.field(Fields.SUM_OF_SQRS_AS_STRING, this.valueFormatter.format(this.sumOfSqrs));
            builder.field(Fields.VARIANCE_AS_STRING, this.valueFormatter.format(this.getVariance()));
            builder.field(Fields.STD_DEVIATION_AS_STRING, this.getStdDeviationAsString());
            builder.startObject(Fields.STD_DEVIATION_BOUNDS_AS_STRING).field(Fields.UPPER, this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER)).field(Fields.LOWER, this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER)).endObject();
        }
        return builder;
    }

    static class Fields {
        public static final XContentBuilderString SUM_OF_SQRS = new XContentBuilderString("sum_of_squares");
        public static final XContentBuilderString SUM_OF_SQRS_AS_STRING = new XContentBuilderString("sum_of_squares_as_string");
        public static final XContentBuilderString VARIANCE = new XContentBuilderString("variance");
        public static final XContentBuilderString VARIANCE_AS_STRING = new XContentBuilderString("variance_as_string");
        public static final XContentBuilderString STD_DEVIATION = new XContentBuilderString("std_deviation");
        public static final XContentBuilderString STD_DEVIATION_AS_STRING = new XContentBuilderString("std_deviation_as_string");
        public static final XContentBuilderString STD_DEVIATION_BOUNDS = new XContentBuilderString("std_deviation_bounds");
        public static final XContentBuilderString STD_DEVIATION_BOUNDS_AS_STRING = new XContentBuilderString("std_deviation_bounds_as_string");
        public static final XContentBuilderString UPPER = new XContentBuilderString("upper");
        public static final XContentBuilderString LOWER = new XContentBuilderString("lower");

        Fields() {
        }
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg,
        sum_of_squares,
        variance,
        std_deviation,
        std_upper,
        std_lower;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

