/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.batch;

import java.util.Map;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchRequest;
import org.apache.camel.component.olingo2.api.batch.Operation;

public class Olingo2BatchChangeRequest
extends Olingo2BatchRequest {
    protected String contentId;
    protected Operation operation;
    protected Object body;

    public Operation getOperation() {
        return this.operation;
    }

    public Object getBody() {
        return this.body;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String toString() {
        return "Batch Change Request{ " + this.resourcePath + ", headers=" + this.headers + ", contentId=" + this.contentId + ", operation=" + (Object)((Object)this.operation) + ", body=" + this.body + '}';
    }

    public static Olingo2BatchChangeRequestBuilder resourcePath(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath");
        }
        return new Olingo2BatchChangeRequestBuilder().resourcePath(resourcePath);
    }

    public static class Olingo2BatchChangeRequestBuilder {
        private Olingo2BatchChangeRequest request = new Olingo2BatchChangeRequest();

        public Olingo2BatchChangeRequestBuilder resourcePath(String resourcePath) {
            this.request.resourcePath = resourcePath;
            return this;
        }

        public Olingo2BatchChangeRequestBuilder headers(Map<String, String> headers) {
            this.request.headers = headers;
            return this;
        }

        public Olingo2BatchChangeRequestBuilder contentId(String contentId) {
            this.request.contentId = contentId;
            return this;
        }

        public Olingo2BatchChangeRequestBuilder operation(Operation operation) {
            this.request.operation = operation;
            return this;
        }

        public Olingo2BatchChangeRequestBuilder body(Object body) {
            this.request.body = body;
            return this;
        }

        public Olingo2BatchChangeRequest build() {
            if (this.request.resourcePath == null) {
                throw new IllegalArgumentException("Null resourcePath");
            }
            if (this.request.operation == null) {
                throw new IllegalArgumentException("Null operation");
            }
            if (this.request.operation != Operation.DELETE && this.request.body == null) {
                throw new IllegalArgumentException("Null body");
            }
            return this.request;
        }
    }
}

