/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleListener;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.embedded.internal.RuntimeServicesManager;
import org.jboss.gravia.runtime.embedded.internal.ServiceState;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractModuleContext;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

final class EmbeddedModuleContext
extends AbstractModuleContext {
    EmbeddedModuleContext(Module module) {
        super(module);
    }

    protected void destroy() {
        super.destroy();
    }

    public void addModuleListener(ModuleListener listener) {
        IllegalArgumentAssertion.assertNotNull((Object)listener, (String)"listener");
        this.assertNotDestroyed();
        this.getEventsManager().addModuleListener(this.getModule(), listener);
    }

    public void removeModuleListener(ModuleListener listener) {
        IllegalArgumentAssertion.assertNotNull((Object)listener, (String)"listener");
        this.assertNotDestroyed();
        this.getEventsManager().removeModuleListener(this.getModule(), listener);
    }

    public void addServiceListener(ServiceListener listener, String filterstr) {
        IllegalArgumentAssertion.assertNotNull((Object)listener, (String)"listener");
        this.assertNotDestroyed();
        this.getEventsManager().addServiceListener(this.getModule(), listener, filterstr);
    }

    public void addServiceListener(ServiceListener listener) {
        IllegalArgumentAssertion.assertNotNull((Object)listener, (String)"listener");
        this.assertNotDestroyed();
        this.getEventsManager().addServiceListener(this.getModule(), listener, null);
    }

    public void removeServiceListener(ServiceListener listener) {
        IllegalArgumentAssertion.assertNotNull((Object)listener, (String)"listener");
        this.assertNotDestroyed();
        this.getEventsManager().removeServiceListener(this.getModule(), listener);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        IllegalArgumentAssertion.assertNotNull(clazz, (String)"clazz");
        IllegalArgumentAssertion.assertNotNull(service, (String)"service");
        this.assertNotDestroyed();
        return this.getServicesManager().registerService((ModuleContext)this, new String[]{clazz.getName()}, service, properties);
    }

    public ServiceRegistration<?> registerService(String className, Object service, Dictionary<String, ?> properties) {
        IllegalArgumentAssertion.assertNotNull((Object)className, (String)"className");
        IllegalArgumentAssertion.assertNotNull((Object)service, (String)"service");
        this.assertNotDestroyed();
        return this.getServicesManager().registerService((ModuleContext)this, new String[]{className}, service, properties);
    }

    public ServiceRegistration<?> registerService(String[] classNames, Object service, Dictionary<String, ?> properties) {
        IllegalArgumentAssertion.assertNotNull((Object)classNames, (String)"classNames");
        IllegalArgumentAssertion.assertNotNull((Object)service, (String)"service");
        this.assertNotDestroyed();
        return this.getServicesManager().registerService((ModuleContext)this, classNames, service, properties);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        IllegalArgumentAssertion.assertNotNull(clazz, (String)"clazz");
        this.assertNotDestroyed();
        return this.getServicesManager().getServiceReference((ModuleContext)this, clazz.getName());
    }

    public ServiceReference<?> getServiceReference(String className) {
        IllegalArgumentAssertion.assertNotNull((Object)className, (String)"className");
        this.assertNotDestroyed();
        return this.getServicesManager().getServiceReference((ModuleContext)this, className);
    }

    public ServiceReference<?>[] getServiceReferences(String className, String filter) {
        this.assertNotDestroyed();
        List<ServiceState<?>> srefs = this.getServicesManager().getServiceReferences((ModuleContext)this, className, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) {
        this.assertNotDestroyed();
        String className = clazz != null ? clazz.getName() : null;
        List<ServiceState<?>> srefs = this.getServicesManager().getServiceReferences((ModuleContext)this, className, filter, true);
        ArrayList result = new ArrayList();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return Collections.unmodifiableList(result);
    }

    public ServiceReference<?>[] getAllServiceReferences(String className, String filter) {
        this.assertNotDestroyed();
        List<ServiceState<?>> srefs = this.getServicesManager().getServiceReferences((ModuleContext)this, className, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (ServiceState<?> serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public boolean ungetService(ServiceReference<?> reference) {
        IllegalArgumentAssertion.assertNotNull(reference, (String)"reference");
        if (this.isDestroyed()) {
            RuntimeLogger.LOGGER.warn("Cannot ungetService " + reference + " from already destroyed module context: " + (Object)((Object)this));
            return false;
        }
        ServiceState serviceState = ServiceState.assertServiceState(reference);
        return this.getServicesManager().ungetService((AbstractModule)this.getModule(), serviceState);
    }

    public <S> S getService(ServiceReference<S> reference) {
        IllegalArgumentAssertion.assertNotNull(reference, (String)"reference");
        this.assertNotDestroyed();
        ServiceState serviceState = ServiceState.assertServiceState(reference);
        return this.getServicesManager().getService((ModuleContext)this, serviceState);
    }

    private RuntimeServicesManager getServicesManager() {
        AbstractRuntime runtime = (AbstractRuntime)this.getModule().adapt(AbstractRuntime.class);
        return (RuntimeServicesManager)runtime.adapt(RuntimeServicesManager.class);
    }

    private RuntimeEventsManager getEventsManager() {
        AbstractRuntime runtime = (AbstractRuntime)this.getModule().adapt(AbstractRuntime.class);
        return (RuntimeEventsManager)runtime.adapt(RuntimeEventsManager.class);
    }
}

