/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityComplexPropertyInfo;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonPropertyEntityProducer {
    public void append(Writer writer, EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginObject().name("d").beginObject();
            jsonStreamWriter.name(propertyInfo.getName());
            JsonPropertyEntityProducer.appendPropertyValue(jsonStreamWriter, propertyInfo.isComplex() ? (EntityComplexPropertyInfo)propertyInfo : propertyInfo, value, true);
            jsonStreamWriter.endObject().endObject();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void appendPropertyValue(JsonStreamWriter jsonStreamWriter, EntityPropertyInfo propertyInfo, Object value, boolean validatingFacets) throws IOException, EdmException, EntityProviderException {
        if (propertyInfo.isComplex()) {
            if (value != null && !(value instanceof Map)) throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"A complex property must have a Map as data"}));
            jsonStreamWriter.beginObject();
            JsonPropertyEntityProducer.appendPropertyMetadata(jsonStreamWriter, propertyInfo.getType());
            for (EntityPropertyInfo childPropertyInfo : ((EntityComplexPropertyInfo)propertyInfo).getPropertyInfos()) {
                jsonStreamWriter.separator();
                String name = childPropertyInfo.getName();
                jsonStreamWriter.name(name);
                JsonPropertyEntityProducer.appendPropertyValue(jsonStreamWriter, childPropertyInfo, value == null ? null : ((Map)value).get(name), validatingFacets);
            }
            jsonStreamWriter.endObject();
            return;
        } else {
            EdmSimpleType type = (EdmSimpleType)propertyInfo.getType();
            Object contentValue = value instanceof Map ? ((Map)value).get(propertyInfo.getName()) : value;
            EdmFacets facets = validatingFacets ? propertyInfo.getFacets() : null;
            String valueAsString = type.valueToString(contentValue, EdmLiteralKind.JSON, facets);
            switch (EdmSimpleTypeKind.valueOf((String)type.getName())) {
                case String: {
                    jsonStreamWriter.stringValue(valueAsString);
                    return;
                }
                case Boolean: 
                case Byte: 
                case SByte: 
                case Int16: 
                case Int32: {
                    jsonStreamWriter.unquotedValue(valueAsString);
                    return;
                }
                case DateTime: 
                case DateTimeOffset: {
                    jsonStreamWriter.stringValueRaw(valueAsString == null ? null : valueAsString.replace("/", "\\/"));
                    return;
                }
                default: {
                    jsonStreamWriter.stringValueRaw(valueAsString);
                }
            }
        }
    }

    protected static void appendPropertyMetadata(JsonStreamWriter jsonStreamWriter, EdmType type) throws IOException, EdmException {
        jsonStreamWriter.name("__metadata").beginObject().namedStringValueRaw("type", type.getNamespace() + "." + type.getName()).endObject();
    }
}

