/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.component.cxf.common.header.CxfHeaderHelper;
import org.apache.camel.component.cxf.common.message.CxfMessageHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.Bus;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CamelOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CamelOutputStream.class);
    private final Message outMessage;
    private boolean isOneWay;
    private String targetCamelEndpointUri;
    private Producer producer;
    private HeaderFilterStrategy headerFilterStrategy;
    private MessageObserver observer;
    private boolean hasLoggedAsyncWarning;

    CamelOutputStream(String targetCamelEndpointUri, Producer producer, HeaderFilterStrategy headerFilterStrategy, MessageObserver observer, Message m) {
        this.targetCamelEndpointUri = targetCamelEndpointUri;
        this.producer = producer;
        this.headerFilterStrategy = headerFilterStrategy;
        this.observer = observer;
        this.outMessage = m;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.outMessage.getExchange().isOneWay();
        this.commitOutputMessage();
    }

    protected void onWrite() throws IOException {
    }

    private void commitOutputMessage() throws IOException {
        ExchangePattern pattern = this.isOneWay ? ExchangePattern.InOnly : ExchangePattern.InOut;
        LOG.debug("send the message to endpoint {}", (Object)this.targetCamelEndpointUri);
        Exchange exchange = this.producer.createExchange(pattern);
        exchange.setProperty("CamelToEndpoint", (Object)this.targetCamelEndpointUri);
        CachedOutputStream outputStream = (CachedOutputStream)this.outMessage.getContent(OutputStream.class);
        CxfHeaderHelper.propagateCxfToCamel(this.headerFilterStrategy, this.outMessage, exchange.getIn().getHeaders(), exchange);
        exchange.getIn().setBody((Object)outputStream.getInputStream());
        LOG.debug("template sending request: ", (Object)exchange.getIn());
        if (this.outMessage.getExchange().isSynchronous()) {
            this.syncInvoke(exchange);
        } else {
            this.asyncInvokeFromWorkQueue(exchange);
        }
    }

    protected void syncInvoke(Exchange exchange) throws IOException {
        try {
            this.producer.process(exchange);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
        }
        Exception exception = exchange.getException();
        if (exception != null) {
            throw new IOException("Cannot send the request message.", exchange.getException());
        }
        exchange.setProperty("org.apache.cxf.message.exchange", (Object)this.outMessage.getExchange());
        if (!this.isOneWay) {
            this.handleResponseInternal(exchange);
        }
    }

    protected void asyncInvokeFromWorkQueue(final Exchange exchange) throws IOException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    CamelOutputStream.this.syncInvoke(exchange);
                }
                catch (Throwable e) {
                    ((PhaseInterceptorChain)CamelOutputStream.this.outMessage.getInterceptorChain()).abort();
                    CamelOutputStream.this.outMessage.setContent(Exception.class, (Object)e);
                    ((PhaseInterceptorChain)CamelOutputStream.this.outMessage.getInterceptorChain()).unwind(CamelOutputStream.this.outMessage);
                    MessageObserver mo = CamelOutputStream.this.outMessage.getInterceptorChain().getFaultObserver();
                    if (mo == null) {
                        mo = (MessageObserver)CamelOutputStream.this.outMessage.getExchange().get(MessageObserver.class);
                    }
                    mo.onMessage(CamelOutputStream.this.outMessage);
                }
            }
        };
        try {
            Executor ex = (Executor)this.outMessage.getExchange().get(Executor.class);
            if (ex != null) {
                this.outMessage.getExchange().put((Object)(Executor.class.getName() + ".USING_SPECIFIED"), (Object)Boolean.TRUE);
                ex.execute(runnable);
            } else {
                WorkQueueManager mgr = (WorkQueueManager)((Bus)this.outMessage.getExchange().get(Bus.class)).getExtension(WorkQueueManager.class);
                AutomaticWorkQueue qu = mgr.getNamedWorkQueue("camel-cxf-conduit");
                if (qu == null) {
                    qu = mgr.getAutomaticWorkQueue();
                }
                qu.execute(runnable);
            }
        }
        catch (RejectedExecutionException rex) {
            if (!this.hasLoggedAsyncWarning) {
                LOG.warn("Executor rejected background task to retrieve the response.  Suggest increasing the workqueue settings.");
                this.hasLoggedAsyncWarning = true;
            }
            LOG.info("Executor rejected background task to retrieve the response, running on current thread.");
            this.syncInvoke(exchange);
        }
    }

    private void handleResponseInternal(Exchange exchange) {
        Message inMessage = null;
        inMessage = CxfMessageHelper.getCxfInMessage(this.headerFilterStrategy, exchange, true);
        this.observer.onMessage(inMessage);
    }
}

