/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.utils;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.oauth2.common.AuthenticationMethod;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;

public final class OAuthUtils {
    private OAuthUtils() {
    }

    public static String setSessionToken(MessageContext mc) {
        return OAuthUtils.setSessionToken(mc, 0);
    }

    public static String setSessionToken(MessageContext mc, int maxInactiveInterval) {
        return OAuthUtils.setSessionToken(mc, OAuthUtils.generateRandomTokenKey());
    }

    public static String setSessionToken(MessageContext mc, String sessionToken) {
        return OAuthUtils.setSessionToken(mc, sessionToken, 0);
    }

    public static String setSessionToken(MessageContext mc, String sessionToken, int maxInactiveInterval) {
        return OAuthUtils.setSessionToken(mc, sessionToken, null, 0);
    }

    public static String setSessionToken(MessageContext mc, String sessionToken, String attribute, int maxInactiveInterval) {
        HttpSession session = mc.getHttpServletRequest().getSession();
        if (maxInactiveInterval > 0) {
            session.setMaxInactiveInterval(maxInactiveInterval);
        }
        String theAttribute = attribute == null ? "session_authenticity_token" : attribute;
        session.setAttribute(theAttribute, (Object)sessionToken);
        return sessionToken;
    }

    public static String getSessionToken(MessageContext mc) {
        return OAuthUtils.getSessionToken(mc, null);
    }

    public static String getSessionToken(MessageContext mc, String attribute) {
        return OAuthUtils.getSessionToken(mc, attribute, true);
    }

    public static String getSessionToken(MessageContext mc, String attribute, boolean remove) {
        String theAttribute;
        HttpSession session = mc.getHttpServletRequest().getSession();
        String sessionToken = (String)session.getAttribute(theAttribute = attribute == null ? "session_authenticity_token" : attribute);
        if (sessionToken != null && remove) {
            session.removeAttribute(theAttribute);
        }
        return sessionToken;
    }

    public static UserSubject createSubject(MessageContext mc, SecurityContext sc) {
        UserSubject subject = (UserSubject)mc.getContent(UserSubject.class);
        if (subject != null) {
            return subject;
        }
        return OAuthUtils.createSubject(sc);
    }

    public static UserSubject createSubject(SecurityContext securityContext) {
        List<String> roleNames = Collections.emptyList();
        if (securityContext instanceof LoginSecurityContext) {
            roleNames = new ArrayList();
            Set roles = ((LoginSecurityContext)securityContext).getUserRoles();
            for (Principal p : roles) {
                roleNames.add(p.getName());
            }
        }
        UserSubject subject = new UserSubject(securityContext.getUserPrincipal().getName(), roleNames);
        Message m = JAXRSUtils.getCurrentMessage();
        if (m != null && m.get(AuthenticationMethod.class) != null) {
            subject.setAuthenticationMethod((AuthenticationMethod)((Object)m.get(AuthenticationMethod.class)));
        }
        return subject;
    }

    public static String convertPermissionsToScope(List<OAuthPermission> perms) {
        StringBuilder sb = new StringBuilder();
        for (OAuthPermission perm : perms) {
            if (perm.isInvisibleToClient() || perm.getPermission() == null) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(perm.getPermission());
        }
        return sb.toString();
    }

    public static List<String> convertPermissionsToScopeList(List<OAuthPermission> perms) {
        LinkedList<String> list = new LinkedList<String>();
        for (OAuthPermission perm : perms) {
            list.add(perm.getPermission());
        }
        return list;
    }

    public static boolean isGrantSupportedForClient(Client client, boolean canSupportPublicClients, String grantType) {
        if (grantType == null || !client.isConfidential() && !canSupportPublicClients) {
            return false;
        }
        List<String> allowedGrants = client.getAllowedGrantTypes();
        return allowedGrants.isEmpty() || allowedGrants.contains(grantType);
    }

    public static List<String> parseScope(String requestedScope) {
        LinkedList<String> list = new LinkedList<String>();
        if (requestedScope != null) {
            String[] scopeValues;
            for (String scope : scopeValues = requestedScope.split(" ")) {
                if (StringUtils.isEmpty((String)scope)) continue;
                list.add(scope);
            }
        }
        return list;
    }

    public static String generateRandomTokenKey() throws OAuthServiceException {
        return OAuthUtils.generateRandomTokenKey(16);
    }

    public static String generateRandomTokenKey(int byteSize) {
        if (byteSize < 16) {
            throw new OAuthServiceException();
        }
        return StringUtils.toHexString((byte[])CryptoUtils.generateSecureRandomBytes((int)byteSize));
    }

    public static long getIssuedAt() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isExpired(Long issuedAt, Long lifetime) {
        return lifetime == null || lifetime < -1L || lifetime > 0L && issuedAt + lifetime < System.currentTimeMillis() / 1000L;
    }

    public static boolean validateAudience(String providedAudience, List<String> allowedAudiences) {
        return providedAudience == null || OAuthUtils.validateAudiences(Collections.singletonList(providedAudience), allowedAudiences);
    }

    public static boolean validateAudiences(List<String> providedAudiences, List<String> allowedAudiences) {
        return StringUtils.isEmpty(providedAudiences) && StringUtils.isEmpty(allowedAudiences) || allowedAudiences.containsAll(providedAudiences);
    }

    public static boolean checkRequestURI(String servletPath, String uri) {
        boolean wildcard = uri.endsWith("*");
        String theURI = wildcard ? uri.substring(0, uri.length() - 1) : uri;
        try {
            URITemplate template = new URITemplate(theURI);
            MetadataMap map = new MetadataMap();
            if (template.match(servletPath, (MultivaluedMap)map)) {
                String finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP");
                if (wildcard || StringUtils.isEmpty((String)finalGroup) || "/".equals(finalGroup)) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    public static List<String> getRequestedScopes(Client client, String scopeParameter, boolean useAllClientScopes, boolean partialMatchScopeValidation) {
        List<String> requestScopes = OAuthUtils.parseScope(scopeParameter);
        List<String> registeredScopes = client.getRegisteredScopes();
        if (requestScopes.isEmpty()) {
            requestScopes.addAll(registeredScopes);
            return requestScopes;
        }
        if (!OAuthUtils.validateScopes(requestScopes, registeredScopes, partialMatchScopeValidation)) {
            throw new OAuthServiceException("Unexpected scope");
        }
        if (useAllClientScopes) {
            for (String registeredScope : registeredScopes) {
                if (requestScopes.contains(registeredScope)) continue;
                requestScopes.add(registeredScope);
            }
        }
        return requestScopes;
    }

    public static boolean validateScopes(List<String> requestScopes, List<String> registeredScopes, boolean partialMatchScopeValidation) {
        if (!registeredScopes.isEmpty()) {
            if (!partialMatchScopeValidation) {
                return registeredScopes.containsAll(requestScopes);
            }
            for (String requestScope : requestScopes) {
                boolean match = false;
                for (String registeredScope : registeredScopes) {
                    if (!requestScope.startsWith(registeredScope)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static ClientAccessToken toClientAccessToken(ServerAccessToken serverToken, boolean supportOptionalParams) {
        ClientAccessToken clientToken = new ClientAccessToken(serverToken.getTokenType(), serverToken.getTokenKey());
        clientToken.setRefreshToken(serverToken.getRefreshToken());
        if (supportOptionalParams) {
            clientToken.setExpiresIn(serverToken.getExpiresIn());
            List<OAuthPermission> perms = serverToken.getScopes();
            String scopeString = OAuthUtils.convertPermissionsToScope(perms);
            if (!StringUtils.isEmpty((String)scopeString)) {
                clientToken.setApprovedScope(scopeString);
            }
            clientToken.setParameters(serverToken.getParameters());
        }
        return clientToken;
    }

    public static JwsSignatureProvider getClientSecretSignatureProvider(String clientSecret) {
        Properties sigProps = JwsUtils.loadSignatureOutProperties((boolean)false);
        return JwsUtils.getHmacSignatureProvider((String)clientSecret, (SignatureAlgorithm)OAuthUtils.getClientSecretSignatureAlgorithm(sigProps));
    }

    public static JwsSignatureVerifier getClientSecretSignatureVerifier(String clientSecret) {
        Properties sigProps = JwsUtils.loadSignatureOutProperties((boolean)false);
        return JwsUtils.getHmacSignatureVerifier((String)clientSecret, (SignatureAlgorithm)OAuthUtils.getClientSecretSignatureAlgorithm(sigProps));
    }

    public static JweDecryptionProvider getClientSecretDecryptionProvider(String clientSecret) {
        Properties props = JweUtils.loadEncryptionInProperties((boolean)false);
        byte[] key = StringUtils.toBytesUTF8((String)clientSecret);
        return JweUtils.getDirectKeyJweDecryption((byte[])key, (ContentAlgorithm)OAuthUtils.getClientSecretContentAlgorithm(props));
    }

    public static JweEncryptionProvider getClientSecretEncryptionProvider(String clientSecret) {
        Properties props = JweUtils.loadEncryptionInProperties((boolean)false);
        byte[] key = StringUtils.toBytesUTF8((String)clientSecret);
        return JweUtils.getDirectKeyJweEncryption((byte[])key, (ContentAlgorithm)OAuthUtils.getClientSecretContentAlgorithm(props));
    }

    private static ContentAlgorithm getClientSecretContentAlgorithm(Properties props) {
        ContentAlgorithm ctAlgo;
        String ctAlgoProp = props.getProperty("client.secret.content.encryption.algorithm");
        if (ctAlgoProp == null) {
            ctAlgoProp = props.getProperty("rs.security.encryption.content.algorithm");
        }
        ctAlgo = (ctAlgo = ContentAlgorithm.getAlgorithm((String)ctAlgoProp)) != null ? ctAlgo : ContentAlgorithm.A128GCM;
        return ctAlgo;
    }

    public static SignatureAlgorithm getClientSecretSignatureAlgorithm(Properties sigProps) {
        SignatureAlgorithm sigAlgo;
        String sigProp;
        String clientSecretSigProp = sigProps.getProperty("client.secret.signature.algorithm");
        if (clientSecretSigProp == null && AlgorithmUtils.isHmacSign((String)(sigProp = sigProps.getProperty("rs.security.signature.algorithm")))) {
            clientSecretSigProp = sigProp;
        }
        SignatureAlgorithm signatureAlgorithm = sigAlgo = (sigAlgo = SignatureAlgorithm.getAlgorithm((String)clientSecretSigProp)) != null ? sigAlgo : SignatureAlgorithm.HS256;
        if (!AlgorithmUtils.isHmacSign((SignatureAlgorithm)sigAlgo)) {
            throw new OAuthServiceException("server_error");
        }
        return sigAlgo;
    }
}

