/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.queries.regex;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.lucene.sandbox.queries.regex.RegexCapabilities;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.REProgram;

@Deprecated
public class JakartaRegexpCapabilities
implements RegexCapabilities {
    private static Field prefixField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        @SuppressForbidden(reason="This class needs to access to the 'prefix' private field in Jakarta's REProgram. This class will be removed in Lucene 6.")
        public Field run() {
            try {
                Field f = REProgram.class.getDeclaredField("prefix");
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                return null;
            }
        }
    });
    private int flags = 0;
    public static final int FLAG_MATCH_NORMAL = 0;
    public static final int FLAG_MATCH_CASEINDEPENDENT = 1;

    public JakartaRegexpCapabilities() {
    }

    public JakartaRegexpCapabilities(int flags) {
        this.flags = flags;
    }

    @Override
    public RegexCapabilities.RegexMatcher compile(String regex) {
        return new JakartaRegexMatcher(regex, this.flags);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JakartaRegexpCapabilities other = (JakartaRegexpCapabilities)obj;
        return this.flags == other.flags;
    }

    class JakartaRegexMatcher
    implements RegexCapabilities.RegexMatcher {
        private RE regexp;
        private final CharsRefBuilder utf16 = new CharsRefBuilder();
        private final CharacterIterator utf16wrapper = new CharacterIterator(){

            public char charAt(int pos) {
                return JakartaRegexMatcher.this.utf16.charAt(pos);
            }

            public boolean isEnd(int pos) {
                return pos >= JakartaRegexMatcher.this.utf16.length();
            }

            public String substring(int beginIndex) {
                return this.substring(beginIndex, JakartaRegexMatcher.this.utf16.length());
            }

            public String substring(int beginIndex, int endIndex) {
                return new String(JakartaRegexMatcher.this.utf16.chars(), beginIndex, endIndex - beginIndex);
            }
        };

        public JakartaRegexMatcher(String regex, int flags) {
            this.regexp = new RE(regex, flags);
        }

        @Override
        public boolean match(BytesRef term) {
            this.utf16.copyUTF8Bytes(term);
            return this.regexp.match(this.utf16wrapper, 0);
        }

        @Override
        public String prefix() {
            try {
                if (prefixField == null) {
                    return null;
                }
                char[] prefix = (char[])prefixField.get(this.regexp.getProgram());
                return prefix == null ? null : new String(prefix);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

