/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal;

import com.github.kristofa.brave.internal.zipkin.Annotation;
import com.github.kristofa.brave.internal.zipkin.BinaryAnnotation;
import com.github.kristofa.brave.internal.zipkin.Codec;
import com.github.kristofa.brave.internal.zipkin.Endpoint;
import com.github.kristofa.brave.internal.zipkin.Span;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.SpanCodec;
import java.util.ArrayList;
import java.util.List;

public final class DefaultSpanCodec
implements SpanCodec {
    public static final SpanCodec JSON = new DefaultSpanCodec(Codec.JSON);
    public static final SpanCodec THRIFT = new DefaultSpanCodec(Codec.THRIFT);
    private final Codec codec;

    private DefaultSpanCodec(Codec codec) {
        this.codec = codec;
    }

    @Override
    public byte[] writeSpan(com.twitter.zipkin.gen.Span span) {
        return this.codec.writeSpan(DefaultSpanCodec.from(span));
    }

    @Override
    public byte[] writeSpans(List<com.twitter.zipkin.gen.Span> spans) {
        ArrayList<Span> out = new ArrayList<Span>(spans.size());
        for (com.twitter.zipkin.gen.Span span : spans) {
            out.add(DefaultSpanCodec.from(span));
        }
        return this.codec.writeSpans(out);
    }

    @Override
    public com.twitter.zipkin.gen.Span readSpan(byte[] bytes) {
        Span in = this.codec.readSpan(bytes);
        com.twitter.zipkin.gen.Span result = new com.twitter.zipkin.gen.Span();
        result.setTrace_id(in.traceId);
        result.setId(in.id);
        result.setParent_id(in.parentId);
        result.setName(in.name);
        result.setTimestamp(in.timestamp);
        result.setDuration(in.duration);
        result.setDebug(in.debug);
        for (Annotation annotation : in.annotations) {
            result.addToAnnotations(com.twitter.zipkin.gen.Annotation.create(annotation.timestamp, annotation.value, DefaultSpanCodec.to(annotation.endpoint)));
        }
        for (BinaryAnnotation binaryAnnotation : in.binaryAnnotations) {
            result.addToBinary_annotations(com.twitter.zipkin.gen.BinaryAnnotation.create(binaryAnnotation.key, binaryAnnotation.value, AnnotationType.fromValue(binaryAnnotation.type.value), DefaultSpanCodec.to(binaryAnnotation.endpoint)));
        }
        return result;
    }

    private static Span from(com.twitter.zipkin.gen.Span in) {
        Span.Builder result = new Span.Builder();
        result.traceId(in.getTrace_id());
        result.id(in.getId());
        result.parentId(in.getParent_id());
        result.name(in.getName());
        result.timestamp(in.getTimestamp());
        result.duration(in.getDuration());
        result.debug(in.isDebug());
        for (com.twitter.zipkin.gen.Annotation annotation : in.getAnnotations()) {
            result.addAnnotation(Annotation.create(annotation.timestamp, annotation.value, DefaultSpanCodec.from(annotation.host)));
        }
        for (com.twitter.zipkin.gen.BinaryAnnotation binaryAnnotation : in.getBinary_annotations()) {
            result.addBinaryAnnotation(new BinaryAnnotation.Builder().key(binaryAnnotation.key).value(binaryAnnotation.value).type(BinaryAnnotation.Type.fromValue(binaryAnnotation.type.getValue())).endpoint(DefaultSpanCodec.from(binaryAnnotation.host)).build());
        }
        return result.build();
    }

    private static Endpoint from(com.twitter.zipkin.gen.Endpoint host) {
        if (host == null) {
            return null;
        }
        if (host.port == null) {
            return Endpoint.create(host.service_name, host.ipv4);
        }
        return Endpoint.create(host.service_name, host.ipv4, host.port.shortValue());
    }

    private static com.twitter.zipkin.gen.Endpoint to(Endpoint host) {
        if (host == null) {
            return null;
        }
        if (host.port == null) {
            return com.twitter.zipkin.gen.Endpoint.create(host.serviceName, host.ipv4);
        }
        return com.twitter.zipkin.gen.Endpoint.create(host.serviceName, host.ipv4, host.port.shortValue());
    }
}

