/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import java.io.Serializable;

public class Endpoint
implements Serializable {
    static final long serialVersionUID = 1L;
    public final int ipv4;
    @Nullable
    public final Short port;
    public final String service_name;

    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, (short)(port & 0xFFFF));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null);
    }

    Endpoint(String service_name, int ipv4, Short port) {
        this.ipv4 = ipv4;
        this.port = port;
        service_name = service_name != null ? service_name.toLowerCase() : "";
        this.service_name = service_name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return this.service_name.equals(that.service_name) && this.ipv4 == that.ipv4 && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.service_name.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }
}

