/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import org.apache.camel.component.mongodb.MongoDbTailTrackingConfig;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbTailTrackingManager {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbTailTrackingManager.class);
    public Object lastVal;
    private final MongoClient connection;
    private final MongoDbTailTrackingConfig config;
    private MongoCollection<BasicDBObject> dbCol;
    private BasicDBObject trackingObj;

    public MongoDbTailTrackingManager(MongoClient connection, MongoDbTailTrackingConfig config) {
        this.connection = connection;
        this.config = config;
    }

    public void initialize() throws Exception {
        if (!this.config.persistent) {
            return;
        }
        this.dbCol = this.connection.getDatabase(this.config.db).getCollection(this.config.collection, BasicDBObject.class);
        BasicDBObject filter = new BasicDBObject("persistentId", (Object)this.config.persistentId);
        this.trackingObj = (BasicDBObject)this.dbCol.find((Bson)filter).first();
        if (this.trackingObj == null) {
            this.dbCol.insertOne((Object)filter);
            this.trackingObj = (BasicDBObject)this.dbCol.find((Bson)filter).first();
        }
        this.trackingObj = new BasicDBObject("_id", this.trackingObj.get("_id"));
    }

    public synchronized void persistToStore() {
        if (!this.config.persistent || this.lastVal == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting lastVal={} to store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        BasicDBObject updateObj = new BasicDBObject().append("$set", (Object)new BasicDBObject(this.config.field, this.lastVal));
        this.dbCol.updateOne((Bson)this.trackingObj, (Bson)updateObj);
        this.trackingObj = (BasicDBObject)this.dbCol.find().first();
    }

    public synchronized Object recoverFromStore() {
        if (!this.config.persistent) {
            return null;
        }
        this.lastVal = ((BasicDBObject)this.dbCol.find((Bson)this.trackingObj).first()).get(this.config.field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovered lastVal={} from store, collection: {}", this.lastVal, (Object)this.config.collection);
        }
        return this.lastVal;
    }

    public void setLastVal(DBObject o) {
        if (this.config.increasingField == null) {
            return;
        }
        this.lastVal = o.get(this.config.increasingField);
    }

    public String getIncreasingFieldName() {
        return this.config.increasingField;
    }
}

