/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Named;
import org.apache.camel.cdi.NamedLiteral;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteRemovedEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.management.event.RouteStoppedEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.ObjectHelper;

final class CdiEventNotifier
extends EventNotifierSupport {
    private final BeanManager manager;
    private final Annotation[] qualifiers;

    CdiEventNotifier(BeanManager manager, Collection<Annotation> qualifiers) {
        this.manager = manager;
        this.qualifiers = qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public void notify(EventObject event) {
        String id = null;
        if (event instanceof RouteAddedEvent) {
            id = ((RouteAddedEvent)event).getRoute().getId();
        } else if (event instanceof RouteStartedEvent) {
            id = ((RouteStartedEvent)event).getRoute().getId();
        } else if (event instanceof RouteStoppedEvent) {
            id = ((RouteStoppedEvent)event).getRoute().getId();
        } else if (event instanceof RouteRemovedEvent) {
            id = ((RouteRemovedEvent)event).getRoute().getId();
        }
        if (ObjectHelper.isNotEmpty((Object)id)) {
            ArrayList<Named> annotations = new ArrayList<Named>();
            Collections.addAll(annotations, this.qualifiers);
            annotations.add(NamedLiteral.of(id));
            this.manager.fireEvent((Object)event, (Annotation[])annotations.stream().toArray(Annotation[]::new));
        } else {
            this.manager.fireEvent((Object)event, this.qualifiers);
        }
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }
}

