/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored.template.ast;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.sql.stored.template.ast.ValueExtractor;
import org.apache.camel.component.sql.stored.template.generated.Token;

public class InputParameter {
    private final String name;
    private final int sqlType;
    private ValueExtractor valueExtractor;

    public InputParameter(String name, int sqlType, Token valueSrcToken) {
        this.name = name;
        this.sqlType = sqlType;
        this.parseValueExpression(valueSrcToken);
    }

    private void parseValueExpression(Token valueSrcToken) {
        if (12 == valueSrcToken.kind) {
            final Expression exp = ExpressionBuilder.simpleExpression((String)valueSrcToken.toString());
            this.valueExtractor = new ValueExtractor(){

                @Override
                public Object eval(Exchange exchange, Object container) {
                    return exp.evaluate(exchange, Object.class);
                }
            };
        } else if (13 == valueSrcToken.kind) {
            final String mapKey = valueSrcToken.toString().substring(2);
            this.valueExtractor = new ValueExtractor(){

                @Override
                public Object eval(Exchange exchange, Object container) {
                    return ((Map)container).get(mapKey);
                }
            };
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public ValueExtractor getValueExtractor() {
        return this.valueExtractor;
    }
}

