/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.scriptengines.jruby;

import com.google.code.scriptengines.jruby.ScriptEngineFactoryLookup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyScriptEngineManager {
    private final ClassLoader loader;
    private final String serviceName = "META-INF/services/javax.script.ScriptEngineFactory";
    private HashSet<ScriptEngineFactory> lookupedFactories;
    private final HashMap<String, ScriptEngine> nameMap = new HashMap();
    private final HashMap<String, ScriptEngine> extensionMap = new HashMap();
    private final HashMap<String, ScriptEngine> mimeTypeMap = new HashMap();
    private Bindings globalScope = new SimpleBindings();

    public JRubyScriptEngineManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JRubyScriptEngineManager(ClassLoader loader) {
        this.loader = loader;
        this.init();
    }

    private void init() {
        this.lookupedFactories = ScriptEngineFactoryLookup.lookup(this.loader, "META-INF/services/javax.script.ScriptEngineFactory");
        for (ScriptEngineFactory factory : this.lookupedFactories) {
            this.registerEngineNames(factory);
            this.registerEngineExtenstions(factory);
            this.registerEngineMimeTypes(factory);
        }
    }

    private void registerEngineExtenstions(ScriptEngineFactory factory) {
        List<String> extensions = factory.getExtensions();
        for (String extension : extensions) {
            this.extensionMap.put(extension, factory.getScriptEngine());
        }
    }

    private void registerEngineMimeTypes(ScriptEngineFactory factory) {
        List<String> mimeTypes = factory.getMimeTypes();
        for (String mimeType : mimeTypes) {
            this.mimeTypeMap.put(mimeType, factory.getScriptEngine());
        }
    }

    private void registerEngineNames(ScriptEngineFactory factory) {
        List<String> names = factory.getNames();
        for (String name : names) {
            this.nameMap.put(name, factory.getScriptEngine());
        }
    }

    public void setBindings(Bindings bindings) {
        this.globalScope = bindings;
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void put(String key, Object value) {
        this.globalScope.put(key, value);
    }

    public Object get(String key) {
        return this.globalScope.get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        ScriptEngine engine = this.nameMap.get(shortName);
        if (engine != null) {
            return engine;
        }
        throw new IllegalArgumentException("no engine registered for: " + shortName);
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngine engine = this.extensionMap.get(extension);
        if (engine != null) {
            return engine;
        }
        throw new IllegalArgumentException("no engine registered for: " + extension);
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngine engine = this.mimeTypeMap.get(mimeType);
        if (engine != null) {
            return engine;
        }
        throw new IllegalArgumentException("no engine registered for: " + mimeType);
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return new ArrayList<ScriptEngineFactory>(this.lookupedFactories);
    }

    public void resigterEngineName(String name, ScriptEngineFactory factory) {
        if (name != null && factory != null) {
            this.nameMap.put(name, factory.getScriptEngine());
        }
    }

    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        if (type != null && factory != null) {
            this.mimeTypeMap.put(type, factory.getScriptEngine());
        }
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension != null && factory != null) {
            this.extensionMap.put(extension, factory.getScriptEngine());
        }
    }
}

