/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.ep;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;

public class EntityProviderWriteProperties {
    private URI serviceRoot;
    private InlineCount inlineCountType;
    private Integer inlineCount;
    private String nextLink;
    private ExpandSelectTreeNode expandSelectTree;
    private Map<String, ODataCallback> callbacks = Collections.emptyMap();
    private URI selfLink;
    private boolean includeSimplePropertyType;
    private Map<String, Map<String, Object>> additionalLinks;
    private boolean omitJsonWrapper;
    private boolean contentOnly;
    private boolean omitETag;
    private boolean validatingFacets = true;
    private boolean isResponsePayload = true;
    private boolean includeMetadataInContentOnly = false;

    private EntityProviderWriteProperties() {
    }

    public final boolean isOmitETag() {
        return this.omitETag;
    }

    public final boolean isContentOnly() {
        return this.contentOnly;
    }

    public final boolean isOmitJsonWrapper() {
        return this.omitJsonWrapper;
    }

    public final boolean isIncludeSimplePropertyType() {
        return this.includeSimplePropertyType;
    }

    public final URI getSelfLink() {
        return this.selfLink;
    }

    public final URI getServiceRoot() {
        return this.serviceRoot;
    }

    public final InlineCount getInlineCountType() {
        return this.inlineCountType;
    }

    public final Map<String, ODataCallback> getCallbacks() {
        return this.callbacks;
    }

    public final ExpandSelectTreeNode getExpandSelectTree() {
        return this.expandSelectTree;
    }

    public final Integer getInlineCount() {
        return this.inlineCount;
    }

    public final String getNextLink() {
        return this.nextLink;
    }

    public final Map<String, Map<String, Object>> getAdditionalLinks() {
        return this.additionalLinks;
    }

    public static ODataEntityProviderPropertiesBuilder serviceRoot(URI serviceRoot) {
        return new ODataEntityProviderPropertiesBuilder().serviceRoot(serviceRoot);
    }

    public boolean isValidatingFacets() {
        return this.validatingFacets;
    }

    public boolean isResponsePayload() {
        return this.isResponsePayload;
    }

    public boolean isIncludeMetadataInContentOnly() {
        return this.includeMetadataInContentOnly;
    }

    public static ODataEntityProviderPropertiesBuilder fromProperties(EntityProviderWriteProperties properties) {
        ODataEntityProviderPropertiesBuilder builder = EntityProviderWriteProperties.serviceRoot(properties.getServiceRoot());
        return builder.fromProperties(properties);
    }

    public static class ODataEntityProviderPropertiesBuilder {
        private final EntityProviderWriteProperties properties = new EntityProviderWriteProperties();

        public final ODataEntityProviderPropertiesBuilder includeSimplePropertyType(boolean includeSimplePropertyType) {
            this.properties.includeSimplePropertyType = includeSimplePropertyType;
            return this;
        }

        public final ODataEntityProviderPropertiesBuilder inlineCountType(InlineCount inlineCountType) {
            this.properties.inlineCountType = inlineCountType;
            return this;
        }

        public final ODataEntityProviderPropertiesBuilder inlineCount(Integer inlineCount) {
            this.properties.inlineCount = inlineCount;
            return this;
        }

        public final ODataEntityProviderPropertiesBuilder serviceRoot(URI serviceRoot) {
            this.properties.serviceRoot = serviceRoot;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder nextLink(String nextLink) {
            this.properties.nextLink = nextLink;
            return this;
        }

        public final EntityProviderWriteProperties build() {
            return this.properties;
        }

        public ODataEntityProviderPropertiesBuilder expandSelectTree(ExpandSelectTreeNode expandSelectTree) {
            this.properties.expandSelectTree = expandSelectTree;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder callbacks(Map<String, ODataCallback> callbacks) {
            this.properties.callbacks = callbacks;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder selfLink(URI selfLink) {
            this.properties.selfLink = selfLink;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder additionalLinks(Map<String, Map<String, Object>> links) {
            this.properties.additionalLinks = links;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder omitJsonWrapper(boolean omitJsonWrapper) {
            this.properties.omitJsonWrapper = omitJsonWrapper;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder contentOnly(boolean contentOnly) {
            this.properties.contentOnly = contentOnly;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder omitETag(boolean omitETag) {
            this.properties.omitETag = omitETag;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder validatingFacets(boolean validatingFacets) {
            this.properties.validatingFacets = validatingFacets;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder responsePayload(boolean responsePayload) {
            this.properties.isResponsePayload = responsePayload;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder includeMetadataInContentOnly(boolean includeMetadataInContentOnly) {
            this.properties.includeMetadataInContentOnly = includeMetadataInContentOnly;
            return this;
        }

        public ODataEntityProviderPropertiesBuilder fromProperties(EntityProviderWriteProperties properties) {
            this.properties.inlineCountType = properties.getInlineCountType();
            this.properties.inlineCount = properties.getInlineCount();
            this.properties.nextLink = properties.getNextLink();
            this.properties.expandSelectTree = properties.getExpandSelectTree();
            this.properties.callbacks = properties.getCallbacks();
            this.properties.selfLink = properties.getSelfLink();
            this.properties.includeSimplePropertyType = properties.includeSimplePropertyType;
            this.properties.additionalLinks = properties.additionalLinks;
            this.properties.omitJsonWrapper = properties.omitJsonWrapper;
            this.properties.contentOnly = properties.contentOnly;
            this.properties.omitETag = properties.omitETag;
            this.properties.validatingFacets = properties.validatingFacets;
            this.properties.isResponsePayload = properties.isResponsePayload;
            this.properties.includeMetadataInContentOnly = properties.includeMetadataInContentOnly;
            return this;
        }
    }
}

