/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.spi;

import java.net.URL;
import java.util.Dictionary;
import java.util.jar.Manifest;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleActivator;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.embedded.spi.BundleContextAdaptor;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.runtime.spi.RuntimePlugin;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class AbstractRuntimePlugin
implements RuntimePlugin,
ModuleActivator {
    private BundleActivator delegate;

    public abstract String getBundleActivator();

    public Module installPluginModule(Runtime runtime, ClassLoader classLoader) throws ModuleException {
        Manifest manifest;
        String resourceName = this.getBundleActivator().replace('.', '/') + ".class";
        URL resurl = classLoader.getResource(resourceName);
        if (resurl == null) {
            RuntimeLogger.LOGGER.debug("Cannot load BundleActivator resource '{}'", (Object)resourceName);
            return null;
        }
        String urlpath = resurl.toExternalForm();
        urlpath = urlpath.substring(0, urlpath.indexOf(resourceName));
        urlpath = urlpath + "META-INF/MANIFEST.MF";
        try {
            manifest = new Manifest(new URL(urlpath).openStream());
        }
        catch (Exception ex) {
            throw new ModuleException("Cannot load plugin manifest: " + urlpath, (Throwable)ex);
        }
        Dictionary headers = new ManifestHeadersProvider(manifest).getHeaders();
        headers.put("Module-Activator", this.getClass().getName());
        return runtime.installModule(classLoader, headers);
    }

    public void start(ModuleContext context) throws Exception {
        this.delegate = (BundleActivator)context.getModule().loadClass(this.getBundleActivator()).newInstance();
        this.delegate.start((BundleContext)new BundleContextAdaptor(context));
    }

    public void stop(ModuleContext context) throws Exception {
        if (this.delegate != null) {
            this.delegate.stop((BundleContext)new BundleContextAdaptor(context));
        }
    }
}

