/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.camel.CamelContext;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.WildFlyCamelContext;

public final class NamingContextAssociationHandler
implements ContextCreateHandler {
    private final ServiceContainer serviceContainer;
    private final ServiceTarget serviceTarget;

    public NamingContextAssociationHandler(ServiceContainer serviceContainer, ServiceTarget serviceTarget) {
        this.serviceContainer = serviceContainer;
        this.serviceTarget = serviceTarget;
    }

    @Override
    public void setup(CamelContext camelctx) {
        if (camelctx instanceof WildFlyCamelContext) {
            WildFlyCamelContext wfctx = (WildFlyCamelContext)camelctx;
            try {
                wfctx.setNamingContext(new CamelNamingContext((ServiceRegistry)this.serviceContainer, this.serviceTarget));
            }
            catch (NamingException ex) {
                throw new IllegalStateException("Cannot initialize naming context", ex);
            }
        }
    }

    static final class CamelNamingContext
    implements Context {
        private final ServiceRegistry serviceRegistry;
        private final ServiceTarget serviceTarget;
        private final Context context;

        CamelNamingContext(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) throws NamingException {
            this.serviceRegistry = serviceRegistry;
            this.serviceTarget = serviceTarget;
            this.context = new InitialContext();
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
            this.addBinderService(name.toString(), obj);
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
            this.addBinderService(name, obj);
        }

        private ServiceController<?> addBinderService(String name, Object obj) {
            final ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
            BinderService binderService = new BinderService(bindInfo.getBindName()){

                public synchronized void start(StartContext context) throws StartException {
                    super.start(context);
                    CamelLogger.LOGGER.info("Bound camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
                }

                public synchronized void stop(StopContext context) {
                    CamelLogger.LOGGER.debug("Unbind camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
                    super.stop(context);
                }
            };
            InjectedValue injector = binderService.getManagedObjectInjector();
            new ManagedReferenceInjector((Injector)injector).inject(obj);
            ServiceBuilder builder = this.serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService);
            builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
            return builder.install();
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.removeBinderService(name.toString());
        }

        @Override
        public void unbind(String name) throws NamingException {
            this.removeBinderService(name);
        }

        private ServiceController<?> removeBinderService(String name) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
            ServiceController controller = this.serviceRegistry.getService(bindInfo.getBinderServiceName());
            if (controller != null) {
                controller.setMode(ServiceController.Mode.REMOVE);
            }
            return controller;
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return this.context.composeName(name, prefix);
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return this.context.composeName(name, prefix);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.context.getEnvironment();
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.context.getNameInNamespace();
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.context.getNameParser(name);
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return this.context.getNameParser(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.context.list(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return this.context.list(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.context.listBindings(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return this.context.listBindings(name);
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.context.lookup(name);
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.context.lookup(name);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.context.lookupLink(name);
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return this.context.lookupLink(name);
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void close() throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
            throw new OperationNotSupportedException();
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
            throw new OperationNotSupportedException();
        }
    }
}

