/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmlsecurity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSecurityDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    @Deprecated
    public static final String XML_ENC_RECIPIENT_ALIAS = "CamelXmlEncryptionRecipientAlias";
    @Deprecated
    public static final String XML_ENC_TRUST_STORE_URL = "CamelXmlEncryptionTrustStoreUrl";
    @Deprecated
    public static final String XML_ENC_TRUST_STORE_PASSWORD = "CamelXmlEncryptionTrustStorePassword";
    @Deprecated
    public static final String XML_ENC_KEY_STORE_URL = "CamelXmlEncryptionKeyStoreUrl";
    @Deprecated
    public static final String XML_ENC_KEY_STORE_PASSWORD = "CamelXmlEncryptionKeyStorePassword";
    @Deprecated
    public static final String XML_ENC_KEY_STORE_ALIAS = "CamelXmlEncryptionKeyAlias";
    private static final Logger LOG = LoggerFactory.getLogger(XMLSecurityDataFormat.class);
    private static final String DEFAULT_KEY = "Just another 24 Byte key";
    private String xmlCipherAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private String keyCipherAlgorithm;
    private String digestAlgorithm;
    private String mgfAlgorithm;
    private byte[] passPhrase;
    private String secureTag = "";
    private boolean secureTagContents = true;
    private KeyStore keyStore;
    private KeyStore trustStore;
    private String keyStorePassword;
    private String trustStorePassword;
    private String recipientKeyAlias;
    private String keyPassword;
    private KeyStoreParameters keyOrTrustStoreParameters;
    private String keyOrTrustStoreParametersId;
    private CamelContext camelContext;
    private DefaultNamespaceContext nsContext = new DefaultNamespaceContext();
    private boolean addKeyValueForEncryptedKey = true;

    public XMLSecurityDataFormat() {
        this.passPhrase = DEFAULT_KEY.getBytes();
        boolean wasSet = false;
        try {
            wasSet = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
                    if (System.getProperty(lineBreakPropName) == null) {
                        System.setProperty(lineBreakPropName, "true");
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Init.init();
        if (!wasSet) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        Field f = XMLUtils.class.getDeclaredField("ignoreLineBreaks");
                        f.setAccessible(true);
                        f.set(null, Boolean.TRUE);
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setNamespaces(namespaces);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, byte[] passPhrase) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setNamespaces(namespaces);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase, String xmlCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    @Deprecated
    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    @Deprecated
    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        if (null != keyOrTrustStoreParametersId && !keyOrTrustStoreParametersId.equals("")) {
            this.keyOrTrustStoreParametersId = keyOrTrustStoreParametersId;
        }
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        if (null != keyOrTrustStoreParametersId && !keyOrTrustStoreParametersId.equals("")) {
            this.keyOrTrustStoreParametersId = keyOrTrustStoreParametersId;
        }
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword, String digestAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
        this.setDigestAlgorithm(digestAlgorithm);
    }

    public String getDataFormatName() {
        return "secureXML";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        try {
            this.setDefaultsFromContext(camelContext);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize XMLSecurityDataFormat with camelContext. ", e);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    @Deprecated
    private void setDefaultsFromContext(CamelContext context) throws Exception {
        Map contextProps = context.getProperties();
        if (this.recipientKeyAlias == null) {
            this.recipientKeyAlias = context.getProperty(XML_ENC_RECIPIENT_ALIAS);
        }
        if (this.trustStore == null && contextProps.containsKey(XML_ENC_TRUST_STORE_URL)) {
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            URL trustStoreUrl = new URL(context.getProperty(XML_ENC_TRUST_STORE_URL));
            if (this.trustStorePassword == null) {
                this.trustStorePassword = context.getProperty(XML_ENC_TRUST_STORE_PASSWORD);
            }
            this.trustStore.load(trustStoreUrl.openStream(), this.trustStorePassword.toCharArray());
        }
        if (this.keyStore == null && contextProps.containsKey(XML_ENC_KEY_STORE_URL)) {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            URL keyStoreUrl = new URL(context.getProperty(XML_ENC_KEY_STORE_URL));
            if (this.keyStorePassword == null) {
                this.keyStorePassword = context.getProperty(XML_ENC_KEY_STORE_PASSWORD);
            }
            this.keyStore.load(keyStoreUrl.openStream(), this.keyStorePassword.toCharArray());
        }
        if (context.getProperties().containsKey(XML_ENC_KEY_STORE_ALIAS) && this.recipientKeyAlias == null) {
            this.recipientKeyAlias = context.getProperty(XML_ENC_KEY_STORE_ALIAS);
        }
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        Document document = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
        if (null != this.keyCipherAlgorithm && (this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") || this.keyCipherAlgorithm.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep"))) {
            this.encryptAsymmetric(exchange, document, stream);
        } else if (null != this.recipientKeyAlias) {
            this.encryptAsymmetric(exchange, document, stream);
        } else {
            this.encryptSymmetric(exchange, document, stream);
        }
    }

    private void encryptAsymmetric(Exchange exchange, Document document, OutputStream stream) throws Exception {
        String exchangeRecipientAlias = this.getRecipientKeyAlias(exchange);
        if (null == exchangeRecipientAlias) {
            throw new IllegalStateException("The  recipient's key alias must be defined for asymmetric key encryption.");
        }
        if (this.trustStore == null && null != this.keyOrTrustStoreParameters) {
            this.trustStore = this.keyOrTrustStoreParameters.createKeyStore();
            this.trustStorePassword = this.keyOrTrustStoreParameters.getPassword();
        }
        if (null == this.trustStore) {
            throw new IllegalStateException("A trust store must be defined for asymmetric key encryption.");
        }
        String password = this.keyPassword != null ? this.keyPassword : this.trustStorePassword;
        Key keyEncryptionKey = this.getPublicKey(this.trustStore, exchangeRecipientAlias, password);
        if (null == keyEncryptionKey) {
            throw new IllegalStateException("No key for the alias [ " + exchangeRecipientAlias + " ] exists in " + "the configured trust store.");
        }
        Key dataEncryptionKey = this.generateDataEncryptionKey();
        XMLCipher keyCipher = null != this.getKeyCipherAlgorithm() ? XMLCipher.getInstance((String)this.getKeyCipherAlgorithm(), null, (String)this.digestAlgorithm) : XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", null, (String)this.digestAlgorithm);
        keyCipher.init(3, keyEncryptionKey);
        this.encrypt(exchange, document, stream, dataEncryptionKey, keyCipher, keyEncryptionKey);
    }

    private void encryptSymmetric(Exchange exchange, Document document, OutputStream stream) throws Exception {
        Key dataEncryptionKey;
        Key keyEncryptionKey;
        if (this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            keyEncryptionKey = this.generateKeyEncryptionKey("DESede");
            dataEncryptionKey = this.generateDataEncryptionKey();
        } else if (this.xmlCipherAlgorithm.equals("http://www.w3.org/2007/05/xmldsig-more#seed128-cbc")) {
            keyEncryptionKey = this.generateKeyEncryptionKey("SEED");
            dataEncryptionKey = this.generateDataEncryptionKey();
        } else if (this.xmlCipherAlgorithm.contains("camellia")) {
            keyEncryptionKey = this.generateKeyEncryptionKey("CAMELLIA");
            dataEncryptionKey = this.generateDataEncryptionKey();
        } else {
            keyEncryptionKey = this.generateKeyEncryptionKey("AES");
            dataEncryptionKey = this.generateDataEncryptionKey();
        }
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.generateXmlCipherAlgorithmKeyWrap());
        keyCipher.init(3, keyEncryptionKey);
        this.encrypt(exchange, document, stream, dataEncryptionKey, keyCipher, keyEncryptionKey);
    }

    private Key getPrivateKey(KeyStore keystore, String alias, String password) throws Exception {
        Key key = keystore.getKey(alias, password.toCharArray());
        if (key instanceof PrivateKey) {
            return key;
        }
        return null;
    }

    private Key getPublicKey(KeyStore keystore, String alias, String password) throws Exception {
        Certificate cert = keystore.getCertificate(alias);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return keystore.getKey(alias, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encrypt(Exchange exchange, Document document, OutputStream stream, Key dataEncryptionKey, XMLCipher keyCipher, Key keyEncryptionKey) throws Exception {
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.xmlCipherAlgorithm);
        xmlCipher.init(1, dataEncryptionKey);
        if (this.secureTag.equalsIgnoreCase("")) {
            this.embedKeyInfoInEncryptedData(document, keyCipher, xmlCipher, dataEncryptionKey, keyEncryptionKey);
            document = xmlCipher.doFinal(document, document.getDocumentElement());
        } else {
            XPathBuilder xpathBuilder = new XPathBuilder(this.secureTag);
            xpathBuilder.setNamespaceContext(this.getNamespaceContext());
            NodeList nodeList = (NodeList)xpathBuilder.evaluate(exchange, NodeList.class);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                document = node.getOwnerDocument();
                this.embedKeyInfoInEncryptedData(node.getOwnerDocument(), keyCipher, xmlCipher, dataEncryptionKey, keyEncryptionKey);
                Document temp = xmlCipher.doFinal(node.getOwnerDocument(), (Element)node, this.getSecureTagContents());
                document.importNode(temp.getDocumentElement().cloneNode(true), true);
            }
        }
        try {
            DOMSource source = new DOMSource(document);
            InputStream sis = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)source);
            IOHelper.copy((InputStream)sis, (OutputStream)stream);
        }
        finally {
            stream.close();
        }
    }

    public Object unmarshal(Exchange exchange, Document document) throws Exception {
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        return this.unmarshal(exchange, is);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Document encodedDocument = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)stream);
        if (null != this.keyCipherAlgorithm && (this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || this.keyCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") || this.keyCipherAlgorithm.equals("http://www.w3.org/2009/xmlenc11#rsa-oaep"))) {
            return this.decodeWithAsymmetricKey(exchange, encodedDocument);
        }
        LOG.debug("No (known) asymmetric keyCipherAlgorithm specified. Attempting to decrypt using a symmetric key");
        return this.decodeWithSymmetricKey(exchange, encodedDocument);
    }

    private Object decodeWithSymmetricKey(Exchange exchange, Document encodedDocument) throws Exception {
        Key keyEncryptionKey = this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") ? this.generateKeyEncryptionKey("DESede") : this.generateKeyEncryptionKey("AES");
        return this.decode(exchange, encodedDocument, keyEncryptionKey);
    }

    private Object decodeWithAsymmetricKey(Exchange exchange, Document encodedDocument) throws Exception {
        if (this.keyStore == null && null != this.keyOrTrustStoreParameters) {
            this.keyStore = this.keyOrTrustStoreParameters.createKeyStore();
            this.keyStorePassword = this.keyOrTrustStoreParameters.getPassword();
        }
        if (this.keyStore == null) {
            throw new IllegalStateException("A key store must be defined for asymmetric key decryption.");
        }
        Key keyEncryptionKey = this.getPrivateKey(this.keyStore, this.recipientKeyAlias, this.keyPassword != null ? this.keyPassword : this.keyStorePassword);
        return this.decode(exchange, encodedDocument, keyEncryptionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decode(Exchange exchange, Document encodedDocument, Key keyEncryptionKey) throws Exception {
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.setSecureValidation(true);
        xmlCipher.init(2, null);
        xmlCipher.setKEK(keyEncryptionKey);
        if (this.secureTag.equalsIgnoreCase("")) {
            this.checkEncryptionAlgorithm(keyEncryptionKey, encodedDocument.getDocumentElement());
            encodedDocument = xmlCipher.doFinal(encodedDocument, encodedDocument.getDocumentElement());
        } else {
            XPathBuilder xpathBuilder = new XPathBuilder(this.secureTag);
            xpathBuilder.setNamespaceContext(this.getNamespaceContext());
            NodeList nodeList = (NodeList)xpathBuilder.evaluate(exchange, NodeList.class);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                encodedDocument = node.getOwnerDocument();
                if (this.getSecureTagContents()) {
                    this.checkEncryptionAlgorithm(keyEncryptionKey, (Element)node);
                    Document temp = xmlCipher.doFinal(encodedDocument, (Element)node, true);
                    encodedDocument.importNode(temp.getDocumentElement().cloneNode(true), true);
                    continue;
                }
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    if (!childNode.getLocalName().equals("EncryptedData")) continue;
                    this.checkEncryptionAlgorithm(keyEncryptionKey, (Element)childNode);
                    Document temp = xmlCipher.doFinal(encodedDocument, (Element)childNode, false);
                    encodedDocument.importNode(temp.getDocumentElement().cloneNode(true), true);
                }
            }
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            DOMSource source = new DOMSource(encodedDocument);
            InputStream sis = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)source);
            IOHelper.copy((InputStream)sis, (OutputStream)bos);
        }
        return bos.toByteArray();
    }

    private Key generateKeyEncryptionKey(String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKey secretKey;
        try {
            if (algorithm.equalsIgnoreCase("DESede")) {
                DESedeKeySpec keySpec = new DESedeKeySpec(this.passPhrase);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                secretKey = keyFactory.generateSecret(keySpec);
            } else {
                secretKey = algorithm.equalsIgnoreCase("SEED") ? new SecretKeySpec(this.passPhrase, "SEED") : (algorithm.equalsIgnoreCase("CAMELLIA") ? new SecretKeySpec(this.passPhrase, "CAMELLIA") : new SecretKeySpec(this.passPhrase, "AES"));
            }
            if (Arrays.equals(this.passPhrase, DEFAULT_KEY.getBytes())) {
                LOG.warn("Using the default encryption key is not secure");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("InvalidKeyException due to invalid passPhrase: " + Arrays.toString(this.passPhrase));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("NoSuchAlgorithmException while using algorithm: " + algorithm);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("Invalid Key generated while using passPhrase: " + Arrays.toString(this.passPhrase));
        }
        return secretKey;
    }

    private Key generateDataEncryptionKey() throws Exception {
        KeyGenerator keyGenerator = null;
        if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            keyGenerator = KeyGenerator.getInstance("DESede");
        } else {
            keyGenerator = KeyGenerator.getInstance("AES");
            if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#seed128-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia128-cbc")) {
                keyGenerator.init(128);
            } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia192-cbc")) {
                keyGenerator.init(192);
            } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia256-cbc")) {
                keyGenerator.init(256);
            }
        }
        return keyGenerator.generateKey();
    }

    private void embedKeyInfoInEncryptedData(Document document, XMLCipher keyCipher, XMLCipher xmlCipher, Key dataEncryptionkey, Key keyEncryptionKey) throws XMLEncryptionException {
        KeyInfo keyInfo;
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, dataEncryptionkey, this.mgfAlgorithm, null);
        if (this.addKeyValueForEncryptedKey && keyEncryptionKey instanceof PublicKey) {
            keyInfo = new KeyInfo(document);
            keyInfo.add((PublicKey)keyEncryptionKey);
            encryptedKey.setKeyInfo(keyInfo);
        }
        keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
        encryptedDataElement.setKeyInfo(keyInfo);
    }

    private String generateXmlCipherAlgorithmKeyWrap() {
        String algorithmKeyWrap = null;
        if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes128-gcm")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes192-gcm")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2009/xmlenc11#aes256-gcm")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#seed128-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2007/05/xmldsig-more#kw-seed128";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia128-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmldsig-more#kw-camellia128";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia192-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmldsig-more#kw-camellia192";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#camellia256-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmldsig-more#kw-camellia256";
        }
        return algorithmKeyWrap;
    }

    private String getRecipientKeyAlias(Exchange exchange) {
        String alias = (String)exchange.getIn().getHeader(XML_ENC_RECIPIENT_ALIAS, String.class);
        if (alias != null) {
            exchange.getIn().setHeader(XML_ENC_RECIPIENT_ALIAS, null);
        } else {
            alias = this.recipientKeyAlias;
        }
        return alias;
    }

    private void checkEncryptionAlgorithm(Key keyEncryptionKey, Element parentElement) throws Exception {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(this.keyCipherAlgorithm) || this.keyCipherAlgorithm == null || !(keyEncryptionKey instanceof PrivateKey)) {
            return;
        }
        Element encryptedElement = this.findEncryptedDataElement(parentElement);
        if (encryptedElement == null) {
            return;
        }
        String foundEncryptedKeyMethod = this.findEncryptedKeyMethod(encryptedElement);
        if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(foundEncryptedKeyMethod)) {
            String errorMessage = "The found key transport encryption method is not allowed";
            throw new XMLEncryptionException(errorMessage);
        }
    }

    private Element findEncryptedDataElement(Element element) {
        if ("EncryptedData".equals(element.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI())) {
            return element;
        }
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !"EncryptedData".equals((childElement = (Element)child).getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(childElement.getNamespaceURI())) continue;
            return childElement;
        }
        return null;
    }

    private String findEncryptionMethod(Element element) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !"EncryptionMethod".equals((childElement = (Element)child).getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(childElement.getNamespaceURI())) continue;
            return childElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    private String findEncryptedKeyMethod(Element element) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (child.getNodeType() != 1 || !"KeyInfo".equals((childElement = (Element)child).getLocalName()) || !"http://www.w3.org/2000/09/xmldsig#".equals(childElement.getNamespaceURI())) continue;
            for (Node keyInfoChild = child.getFirstChild(); keyInfoChild != null; keyInfoChild = keyInfoChild.getNextSibling()) {
                if (child.getNodeType() != 1 || !"EncryptedKey".equals((childElement = (Element)keyInfoChild).getLocalName()) || !"http://www.w3.org/2001/04/xmlenc#".equals(childElement.getNamespaceURI())) continue;
                return this.findEncryptionMethod(childElement);
            }
        }
        return null;
    }

    private DefaultNamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    @Deprecated
    public String getKeyCyperAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public String getKeyCipherAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public void setKeyCipherAlgorithm(String keyCipherAlgorithm) {
        this.keyCipherAlgorithm = keyCipherAlgorithm;
    }

    public String getRecipientKeyAlias() {
        return this.recipientKeyAlias;
    }

    public void setRecipientKeyAlias(String recipientKeyAlias) {
        this.recipientKeyAlias = recipientKeyAlias;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents;
    }

    public boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }

    @Deprecated
    public KeyStore getKeyStore() {
        if (this.keyStore == null && this.keyOrTrustStoreParameters != null) {
            try {
                this.keyStore = this.keyOrTrustStoreParameters.createKeyStore();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create KeyStore with configured KeyStoreParameters. " + e.getMessage(), e);
            }
        }
        return this.keyStore;
    }

    @Deprecated
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Deprecated
    public KeyStore getTrustStore() {
        if (this.trustStore == null && this.keyOrTrustStoreParameters != null) {
            try {
                this.trustStore = this.keyOrTrustStoreParameters.createKeyStore();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create KeyStore with configured KeyStoreParameters. " + e.getMessage(), e);
            }
        }
        return this.trustStore;
    }

    @Deprecated
    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    @Deprecated
    public String getKeyStorePassword() {
        if (this.keyOrTrustStoreParameters != null) {
            return this.keyOrTrustStoreParameters.getPassword();
        }
        return this.keyStorePassword;
    }

    @Deprecated
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Deprecated
    public String getTrustStorePassword() {
        if (this.keyOrTrustStoreParameters != null) {
            return this.keyOrTrustStoreParameters.getPassword();
        }
        return this.trustStorePassword;
    }

    @Deprecated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setKeyOrTrustStoreParameters(KeyStoreParameters parameters) {
        this.keyOrTrustStoreParameters = parameters;
    }

    public KeyStoreParameters getKeyOrTrustStoreParameters() {
        return this.keyOrTrustStoreParameters;
    }

    public void setKeyOrTrustStoreParametersId(String registryId) {
        this.keyOrTrustStoreParametersId = registryId;
        if (this.camelContext != null) {
            Object parametersObj = this.camelContext.getRegistry().lookupByName(this.keyOrTrustStoreParametersId);
            if (parametersObj instanceof KeyStoreParameters) {
                this.keyOrTrustStoreParameters = (KeyStoreParameters)parametersObj;
            } else {
                throw new IllegalStateException("Could not initialize XMLSecurityDataFormat with camelContext.The id for the keyOrTrustStoreParameters specified [ " + this.keyOrTrustStoreParametersId + " ] does not identify a KeyStoreParameters bean.");
            }
        }
    }

    public String getKeyOrTrustStoreParametersId() {
        return this.keyOrTrustStoreParametersId;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.getNamespaceContext().setNamespaces(namespaces);
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getMgfAlgorithm() {
        return this.mgfAlgorithm;
    }

    public void setMgfAlgorithm(String mgfAlgorithm) {
        this.mgfAlgorithm = mgfAlgorithm;
    }

    public boolean isAddKeyValueForEncryptedKey() {
        return this.addKeyValueForEncryptedKey;
    }

    public void setAddKeyValueForEncryptedKey(boolean addKeyValueForEncryptedKey) {
        this.addKeyValueForEncryptedKey = addKeyValueForEncryptedKey;
    }
}

