/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.commons.ContentType;

public class ODataRequestImpl
extends ODataRequest {
    private ODataHttpMethod method;
    private String httpMethod;
    private CaseInsensitiveMap requestHeaders = new CaseInsensitiveMap();
    private InputStream body;
    private PathInfo pathInfo;
    private Map<String, String> queryParameters;
    private Map<String, List<String>> allQueryParameters;
    private List<String> acceptHeaders;
    private ContentType contentType;
    private List<Locale> acceptableLanguages;

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public List<String> getAcceptHeaders() {
        return this.acceptHeaders;
    }

    public String getContentType() {
        return this.contentType == null ? null : this.contentType.toContentTypeString();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.acceptableLanguages;
    }

    public String getRequestHeaderValue(String name) {
        List<String> headerList = this.requestHeaders.get(name);
        return headerList == null || headerList.isEmpty() ? null : headerList.get(0);
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public InputStream getBody() {
        return this.body;
    }

    public ODataHttpMethod getMethod() {
        return this.method;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public PathInfo getPathInfo() {
        return this.pathInfo;
    }

    public Map<String, List<String>> getAllQueryParameters() {
        return this.allQueryParameters;
    }

    private class CaseInsensitiveMap
    extends HashMap<String, List<String>> {
        private static final long serialVersionUID = 1L;

        private CaseInsensitiveMap() {
        }

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(key.toLowerCase(), value);
        }

        public List<String> get(String key) {
            return (List)super.get(key.toLowerCase());
        }

        @Override
        public List<String> get(Object key) {
            String skey = (String)key;
            return (List)super.get(skey.toLowerCase());
        }
    }

    public class ODataRequestBuilderImpl
    extends ODataRequest.ODataRequestBuilder {
        private ODataHttpMethod method;
        private String httpMethod;
        private CaseInsensitiveMap requestHeaders;
        private InputStream body;
        private PathInfo pathInfo;
        private Map<String, List<String>> allQueryParameters;
        private List<String> acceptHeaders;
        private ContentType contentType;
        private List<Locale> acceptableLanguages;

        public ODataRequestBuilderImpl() {
            this.requestHeaders = new CaseInsensitiveMap();
            this.allQueryParameters = new HashMap<String, List<String>>();
        }

        public ODataRequest build() {
            ODataRequestImpl.this.method = this.method;
            ODataRequestImpl.this.httpMethod = this.httpMethod;
            ODataRequestImpl.this.requestHeaders = this.requestHeaders;
            ODataRequestImpl.this.body = this.body;
            ODataRequestImpl.this.pathInfo = this.pathInfo;
            ODataRequestImpl.this.queryParameters = this.convertMultiMaptoSingleMap(this.allQueryParameters);
            ODataRequestImpl.this.allQueryParameters = this.allQueryParameters;
            ODataRequestImpl.this.acceptHeaders = this.acceptHeaders;
            ODataRequestImpl.this.contentType = this.contentType;
            ODataRequestImpl.this.acceptableLanguages = this.acceptableLanguages;
            return ODataRequestImpl.this;
        }

        public ODataRequest.ODataRequestBuilder requestHeaders(Map<String, List<String>> headers) {
            this.requestHeaders = new CaseInsensitiveMap();
            for (Map.Entry<String, List<String>> set : headers.entrySet()) {
                this.requestHeaders.put(set.getKey(), set.getValue());
            }
            return this;
        }

        public ODataRequest.ODataRequestBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public ODataRequest.ODataRequestBuilder body(InputStream body) {
            this.body = body;
            return this;
        }

        public ODataRequest.ODataRequestBuilder pathInfo(PathInfo pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        public ODataRequest.ODataRequestBuilder method(ODataHttpMethod method) {
            this.method = method;
            return this;
        }

        public ODataRequest.ODataRequestBuilder acceptableLanguages(List<Locale> acceptableLanguages) {
            this.acceptableLanguages = acceptableLanguages;
            return this;
        }

        public ODataRequest.ODataRequestBuilder acceptHeaders(List<String> acceptHeaders) {
            this.acceptHeaders = acceptHeaders;
            return this;
        }

        public ODataRequest.ODataRequestBuilder queryParameters(Map<String, String> queryParameters) {
            for (String key : queryParameters.keySet()) {
                LinkedList<String> parameterValues = new LinkedList<String>();
                parameterValues.add(queryParameters.get(key));
                this.allQueryParameters.put(key, parameterValues);
            }
            return this;
        }

        public ODataRequest.ODataRequestBuilder allQueryParameters(Map<String, List<String>> allQueryParameters) {
            this.allQueryParameters = new HashMap<String, List<String>>(allQueryParameters);
            return this;
        }

        public ODataRequest.ODataRequestBuilder contentType(String contentType) {
            this.contentType = ContentType.create(contentType);
            return this;
        }

        public ODataRequest.ODataRequestBuilder fromRequest(ODataRequest request) {
            this.pathInfo = request.getPathInfo();
            this.method = request.getMethod();
            this.httpMethod = request.getHttpMethod();
            this.body = request.getBody();
            if (request.getContentType() != null) {
                this.contentType = ContentType.create(request.getContentType());
            }
            this.requestHeaders = new CaseInsensitiveMap();
            for (Map.Entry set : request.getRequestHeaders().entrySet()) {
                this.requestHeaders.put((String)set.getKey(), (List)set.getValue());
            }
            if (request.getAcceptHeaders() != null) {
                this.acceptHeaders = new ArrayList<String>();
                for (String acceptHeader : request.getAcceptHeaders()) {
                    this.acceptHeaders.add(acceptHeader);
                }
            }
            if (request.getAcceptableLanguages() != null) {
                this.acceptableLanguages = new ArrayList<Locale>();
                for (Locale acceptLanguage : request.getAcceptableLanguages()) {
                    this.acceptableLanguages.add(acceptLanguage);
                }
            }
            if (request.getAllQueryParameters() != null) {
                this.allQueryParameters = new HashMap<String, List<String>>();
                for (Map.Entry queryParameter : request.getAllQueryParameters().entrySet()) {
                    String queryParameterName = (String)queryParameter.getKey();
                    this.allQueryParameters.put(queryParameterName, (List<String>)request.getAllQueryParameters().get(queryParameterName));
                }
            }
            return this;
        }

        private <T, K> Map<T, K> convertMultiMaptoSingleMap(Map<T, List<K>> multiMap) {
            HashMap<T, K> singleMap = new HashMap<T, K>();
            for (T key : multiMap.keySet()) {
                singleMap.put(key, multiMap.get(key).get(0));
            }
            return singleMap;
        }
    }
}

