/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ConsumerGroupCommand$ {
    public static final ConsumerGroupCommand$ MODULE$;

    static {
        new ConsumerGroupCommand$();
    }

    public void main(String[] args) {
        block10: {
            ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "List all consumer groups, describe a consumer group, or delete consumer group info.");
            }
            int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt()}))).count((Function1)new Serializable(opts){
                public static final long serialVersionUID = 0L;
                private final ConsumerGroupCommand.ConsumerGroupCommandOptions opts$1;

                public final boolean apply(OptionSpec<?> x$1) {
                    return this.opts$1.options().has(x$1);
                }
                {
                    this.opts$1 = opts$1;
                }
            });
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete");
            }
            opts.checkArgs();
            try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = opts.options().has((OptionSpec)opts.newConsumerOpt()) ? new ConsumerGroupCommand.KafkaConsumerGroupService(opts) : new ConsumerGroupCommand.ZkConsumerGroupService(opts);){
                try {
                    if (opts.options().has((OptionSpec)opts.listOpt())) {
                        consumerGroupService.list();
                        break block10;
                    }
                    if (opts.options().has((OptionSpec)opts.describeOpt())) {
                        consumerGroupService.describe();
                        break block10;
                    }
                    if (!opts.options().has((OptionSpec)opts.deleteOpt())) break block10;
                    ConsumerGroupCommand.ConsumerGroupService consumerGroupService2 = consumerGroupService;
                    if (consumerGroupService2 instanceof ConsumerGroupCommand.ZkConsumerGroupService) {
                        ConsumerGroupCommand.ZkConsumerGroupService zkConsumerGroupService = (ConsumerGroupCommand.ZkConsumerGroupService)consumerGroupService2;
                        zkConsumerGroupService.delete();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block10;
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete is not supported for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerGroupService})));
                }
                catch (Throwable throwable) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing consumer group command ").append((Object)throwable.getMessage()).toString());
                    Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)throwable));
                }
            }
        }
    }

    private ConsumerGroupCommand$() {
        MODULE$ = this;
    }
}

