/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Protocol;
import org.apache.avro.reflect.ReflectData;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.component.avro.AvroConsumer;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroHttpEndpoint;
import org.apache.camel.component.avro.AvroListener;
import org.apache.camel.component.avro.AvroNettyEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.URISupport;

public class AvroComponent
extends UriEndpointComponent {
    private AvroConfiguration configuration;
    private ConcurrentMap<String, AvroListener> listenerRegistry = new ConcurrentHashMap<String, AvroListener>();

    public AvroComponent() {
        super(AvroEndpoint.class);
    }

    public AvroComponent(CamelContext context) {
        super(context, AvroEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AvroConfiguration config = this.configuration != null ? this.configuration.copy() : new AvroConfiguration();
        URI endpointUri = new URI(URISupport.normalizeUri((String)remaining));
        this.applyToConfiguration(config, endpointUri, parameters);
        if ("netty".equals(endpointUri.getScheme())) {
            return new AvroNettyEndpoint(remaining, (Component)this, config);
        }
        if ("http".equals(endpointUri.getScheme())) {
            return new AvroHttpEndpoint(remaining, (Component)this, config);
        }
        throw new IllegalArgumentException("Unknown avro scheme. Should use either netty or http.");
    }

    private void applyToConfiguration(AvroConfiguration config, URI endpointUri, Map<String, Object> parameters) throws Exception {
        Class protocolClass;
        config.parseURI(endpointUri, parameters, this);
        this.setProperties(config, parameters);
        if (config.getProtocol() == null && config.getProtocolClassName() != null && (protocolClass = this.getCamelContext().getClassResolver().resolveClass(config.getProtocolClassName())) != null) {
            try {
                Field f = protocolClass.getField("PROTOCOL");
                if (f != null) {
                    Protocol protocol = (Protocol)f.get(null);
                    config.setProtocol(protocol);
                }
            }
            catch (NoSuchFieldException e) {
                ReflectData reflectData = ReflectData.get();
                config.setProtocol(reflectData.getProtocol(protocolClass));
                config.setReflectionProtocol(true);
            }
        }
        if (config.getProtocol() == null) {
            throw new IllegalArgumentException("Avro configuration does not contain protocol");
        }
        if (config.getMessageName() != null && !config.getProtocol().getMessages().containsKey(config.getMessageName())) {
            throw new IllegalArgumentException("Message " + config.getMessageName() + " is not defined in protocol");
        }
        if (config.isSingleParameter()) {
            Map messageMap = config.getProtocol().getMessages();
            Collection messagesToCheck = config.getMessageName() == null ? messageMap.values() : Collections.singleton(messageMap.get(config.getMessageName()));
            for (Protocol.Message message : messagesToCheck) {
                if (message.getRequest().getFields().size() == 1) continue;
                throw new IllegalArgumentException("Single parameter option can't be used with message " + message.getName() + " because it has " + message.getRequest().getFields().size() + " parameters defined");
            }
        }
    }

    public void register(String uri, String messageName, AvroConsumer consumer) throws Exception {
        AvroListener listener = (AvroListener)this.listenerRegistry.get(uri);
        if (listener == null) {
            listener = new AvroListener(consumer.getEndpoint());
            this.listenerRegistry.put(uri, listener);
        }
        listener.register(messageName, consumer);
    }

    public void unregister(String uri, String messageName) {
        if (((AvroListener)this.listenerRegistry.get(uri)).unregister(messageName)) {
            this.listenerRegistry.remove(uri);
        }
    }

    public AvroConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AvroConfiguration configuration) {
        this.configuration = configuration;
    }
}

