/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ssh.SshComponent;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshConsumer;
import org.apache.camel.component.ssh.SshProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.sshd.common.KeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="ssh", title="SSH", syntax="ssh:host:port", alternativeSyntax="ssh:username:password@host:port", consumerClass=SshConsumer.class, label="file")
public class SshEndpoint
extends ScheduledPollEndpoint {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @UriParam
    private SshConfiguration sshConfiguration;

    public SshEndpoint() {
    }

    public SshEndpoint(String uri, SshComponent component) {
        super(uri, (Component)component);
    }

    public SshEndpoint(String uri, SshComponent component, SshConfiguration configuration) {
        super(uri, (Component)component);
        this.sshConfiguration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new SshProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SshConsumer consumer = new SshConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public SshConfiguration getConfiguration() {
        return this.sshConfiguration;
    }

    public void setConfiguration(SshConfiguration configuration) {
        this.sshConfiguration = configuration;
    }

    public String getHost() {
        return this.getConfiguration().getHost();
    }

    public void setHost(String host) {
        this.getConfiguration().setHost(host);
    }

    public int getPort() {
        return this.getConfiguration().getPort();
    }

    public void setPort(int port) {
        this.getConfiguration().setPort(port);
    }

    public String getUsername() {
        return this.getConfiguration().getUsername();
    }

    public void setUsername(String username) {
        this.getConfiguration().setUsername(username);
    }

    public String getPassword() {
        return this.getConfiguration().getPassword();
    }

    public void setPassword(String password) {
        this.getConfiguration().setPassword(password);
    }

    public String getPollCommand() {
        return this.getConfiguration().getPollCommand();
    }

    public void setPollCommand(String pollCommand) {
        this.getConfiguration().setPollCommand(pollCommand);
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.getConfiguration().getKeyPairProvider();
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.getConfiguration().setKeyPairProvider(keyPairProvider);
    }

    public String getKeyType() {
        return this.getConfiguration().getKeyType();
    }

    public void setKeyType(String keyType) {
        this.getConfiguration().setKeyType(keyType);
    }

    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    public void setTimeout(long timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    @Deprecated
    public String getCertFilename() {
        return this.getConfiguration().getCertFilename();
    }

    @Deprecated
    public void setCertFilename(String certFilename) {
        this.getConfiguration().setCertFilename(certFilename);
    }

    public String getCertResource() {
        return this.getConfiguration().getCertResource();
    }

    public void setCertResource(String certResource) {
        this.getConfiguration().setCertResource(certResource);
    }
}

