/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionFactoryResource
extends BasePoolableObjectFactory<Connection>
implements ConnectionResource {
    private static final long DEFAULT_WAIT_TIMEOUT = 5000L;
    private static final int DEFAULT_POOL_SIZE = 1;
    private GenericObjectPool<Connection> connections;
    private ConnectionFactory connectionFactory;
    private String username;
    private String password;
    private String clientId;

    public ConnectionFactoryResource() {
        this(1, null);
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory) {
        this(poolSize, connectionFactory, null, null);
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory, String username, String password) {
        this(poolSize, connectionFactory, username, password, null);
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory, String username, String password, String connectionId) {
        this(poolSize, connectionFactory, username, password, connectionId, 5000L);
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory, String username, String password, String connectionId, long maxWait) {
        this.connectionFactory = connectionFactory;
        this.username = username;
        this.password = password;
        this.clientId = connectionId;
        this.connections = new GenericObjectPool((PoolableObjectFactory)this);
        this.connections.setMaxWait(maxWait);
        this.connections.setMaxActive(poolSize);
        this.connections.setMaxIdle(poolSize);
        this.connections.setMinIdle(poolSize);
        this.connections.setLifo(false);
    }

    @Override
    public Connection borrowConnection() throws Exception {
        return (Connection)this.connections.borrowObject();
    }

    @Override
    public void returnConnection(Connection connection) throws Exception {
        this.connections.returnObject((Object)connection);
    }

    public Connection makeObject() throws Exception {
        Connection connection = null;
        if (this.connectionFactory != null) {
            connection = this.getUsername() != null && this.getPassword() != null ? this.connectionFactory.createConnection(this.getUsername(), this.getPassword()) : this.connectionFactory.createConnection();
        }
        if (connection != null) {
            if (ObjectHelper.isNotEmpty((Object)this.getClientId())) {
                connection.setClientID(this.getClientId());
            }
            connection.start();
        }
        return connection;
    }

    public void destroyObject(Connection connection) throws Exception {
        if (connection != null) {
            connection.stop();
            connection.close();
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int size() {
        return this.connections.getNumActive() + this.connections.getNumIdle();
    }

    public void fillPool() throws Exception {
        while (this.connections.getNumIdle() < this.connections.getMaxIdle()) {
            this.connections.addObject();
        }
    }

    public void drainPool() throws Exception {
        this.connections.close();
    }
}

