/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ContainerSqlFragment;
import com.opengamma.elsql.SqlParams;

abstract class ConditionalSqlFragment
extends ContainerSqlFragment {
    private final String _variable;
    private final String _matchValue;

    ConditionalSqlFragment(String variable, String matchValue) {
        this._variable = ConditionalSqlFragment.extractVariableName(variable);
        this._matchValue = matchValue;
    }

    String getVariable() {
        return this._variable;
    }

    String getMatchValue() {
        return this._matchValue;
    }

    boolean isMatch(SqlParams params, int[] loopIndex) {
        String var = this.applyLoopIndex(this._variable, loopIndex);
        if (!params.contains(var)) {
            return false;
        }
        Object value = params.get(var);
        if (value == null) {
            return false;
        }
        if (this._matchValue != null) {
            return this._matchValue.equalsIgnoreCase(value.toString());
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    boolean endsWith(StringBuilder buf, String match) {
        String str = buf.length() >= match.length() ? buf.substring(buf.length() - match.length()) : "";
        return str.equals(match);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + this._variable + " " + this.getFragments();
    }
}

